/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jndi;

import jakarta.transaction.UserTransaction;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction
extends NamingEntry {
    private static final Logger LOG = LoggerFactory.getLogger(Transaction.class);
    public static final String USER_TRANSACTION = "UserTransaction";

    public static void bindToENC() throws NamingException {
        Transaction txEntry = (Transaction)NamingEntryUtil.lookupNamingEntry(null, USER_TRANSACTION);
        if (txEntry == null) {
            throw new NameNotFoundException("UserTransaction not found");
        }
        txEntry.bindToComp();
    }

    public Transaction(UserTransaction userTransaction) throws NamingException {
        super(USER_TRANSACTION);
        this.save(userTransaction);
    }

    @Override
    public void bindToENC(String localName) throws NamingException {
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp/env");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Binding java:comp/env{} to {}", (Object)this.getJndiName(), (Object)this._objectNameString);
        }
        NamingUtil.bind(env, localName, new LinkRef(this._objectNameString));
    }

    private void bindToComp() throws NamingException {
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Binding java:comp/{} to {}", (Object)this.getJndiName(), (Object)this._objectNameString);
        }
        NamingUtil.bind(env, this.getJndiName(), new LinkRef(this._objectNameString));
    }

    @Override
    public void unbindENC() {
        try {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unbinding java:comp/{}", (Object)this.getJndiName());
            }
            env.unbind(this.getJndiName());
        }
        catch (NamingException e) {
            LOG.warn("Unable to unbind java:comp/{}", (Object)this.getJndiName(), (Object)e);
        }
    }
}

