/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import net.opanel.OPanel;
import net.opanel.web.BaseServlet;

public class StaticFileServlet
extends BaseServlet {
    public static final String route = "/";
    private static final String ROOT_PATH = "web";
    private static final String DEFAULT_FILE = "index.html";
    private static final String DEFAULT_RSC_FILE = "index.txt";

    public StaticFileServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        InputStream stream;
        String reqPath = req.getRequestURI();
        if (reqPath.startsWith("/api")) {
            return;
        }
        boolean hasExtension = reqPath.lastIndexOf(".") > reqPath.lastIndexOf(route);
        String resourcePath = ROOT_PATH + reqPath;
        if (!hasExtension) {
            String string = resourcePath = resourcePath.endsWith(route) ? resourcePath + DEFAULT_FILE : resourcePath + "/index.html";
        }
        if (reqPath.contains(".txt") && !reqPath.contains(DEFAULT_RSC_FILE) && req.getParameter("_rsc") != null) {
            resourcePath = ROOT_PATH + reqPath.replace(".txt", "/index.txt");
        }
        if ((stream = this.getClass().getClassLoader().getResourceAsStream(resourcePath)) == null) {
            this.sendResponse(res, 404);
            return;
        }
        try {
            byte[] bytes = stream.readAllBytes();
            stream.close();
            this.sendContentResponse(res, bytes, this.getMimeType(resourcePath));
        }
        catch (IOException e) {
            this.sendResponse(res, 500);
            e.printStackTrace();
        }
    }

    private String getMimeType(String fileName) {
        if (fileName.endsWith(".html") || fileName.endsWith(".htm")) {
            return "text/html";
        }
        if (fileName.endsWith(".css")) {
            return "text/css";
        }
        if (fileName.endsWith(".js")) {
            return "text/javascript";
        }
        if (fileName.endsWith(".json")) {
            return "application/json";
        }
        if (fileName.endsWith(".png")) {
            return "image/png";
        }
        if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (fileName.endsWith(".gif")) {
            return "image/gif";
        }
        if (fileName.endsWith(".svg")) {
            return "image/svg+xml";
        }
        if (fileName.endsWith(".txt")) {
            return "text/plain";
        }
        return "application/octet-stream";
    }
}

