/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.opanel.OPanel;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelServer;
import net.opanel.web.BaseServlet;

public class PlayersServlet
extends BaseServlet {
    public static final String route = "/api/players/*";

    public PlayersServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        OPanelServer server = this.plugin.getServer();
        if (reqPath != null && !reqPath.equals("/")) {
            this.sendResponse(res, 400);
            return;
        }
        boolean isWhitelistEnabled = server.isWhitelistEnabled();
        try {
            List<String> whitelistNames = server.getWhitelist().getNames();
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("maxPlayerCount", server.getMaxPlayerCount());
            obj.put("whitelist", isWhitelistEnabled);
            ArrayList players = new ArrayList();
            for (OPanelPlayer player : server.getPlayers()) {
                HashMap<String, Object> playerInfo = new HashMap<String, Object>();
                playerInfo.put("name", player.getName());
                playerInfo.put("uuid", player.getUUID());
                playerInfo.put("isOnline", player.isOnline());
                playerInfo.put("isOp", player.isOp());
                playerInfo.put("isBanned", player.isBanned());
                playerInfo.put("gamemode", player.getGameMode().getName());
                playerInfo.put("banReason", player.getBanReason());
                if (isWhitelistEnabled) {
                    playerInfo.put("isWhitelisted", whitelistNames.contains(player.getName()));
                }
                players.add(playerInfo);
            }
            obj.put("players", players);
            this.sendResponse(res, obj);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(res, 500);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        OPanelServer server = this.plugin.getServer();
        if (reqPath == null || reqPath.equals("/")) {
            this.sendResponse(res, 400);
            return;
        }
        String uuid = req.getParameter("uuid");
        String reason = req.getParameter("r");
        String gamemode = req.getParameter("gm");
        if (uuid == null) {
            this.sendResponse(res, 400);
            return;
        }
        OPanelPlayer player = server.getPlayer(uuid);
        switch (reqPath.substring(1)) {
            case "op": {
                player.giveOp();
                break;
            }
            case "deop": {
                player.depriveOp();
                break;
            }
            case "kick": {
                if (!player.isOnline()) {
                    this.sendResponse(res, 403);
                    return;
                }
                player.kick(reason);
                break;
            }
            case "ban": {
                player.ban(reason);
                break;
            }
            case "pardon": {
                player.pardon();
                break;
            }
            case "gamemode": {
                if (gamemode == null) {
                    this.sendResponse(res, 400);
                    return;
                }
                player.setGameMode(OPanelGameMode.fromString(gamemode));
            }
        }
        this.sendResponse(res, 200);
    }
}

