/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.opanel.OPanel;
import net.opanel.common.OPanelServer;
import net.opanel.utils.TPS;
import net.opanel.utils.Utils;
import net.opanel.web.BaseServlet;

public class InfoServlet
extends BaseServlet {
    public static final String route = "/api/info/*";

    public InfoServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        OPanelServer server = this.plugin.getServer();
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("favicon", server.getFavicon() != null ? "/api/icon" : null);
        obj.put("motd", Utils.stringToBase64(server.getMotd()));
        obj.put("version", server.getVersion());
        obj.put("port", server.getPort());
        obj.put("maxPlayerCount", server.getMaxPlayerCount());
        obj.put("whitelist", server.isWhitelistEnabled());
        obj.put("uptime", this.plugin.getUptimer().getCurrent());
        HashMap<String, Object> ingameTimeObj = new HashMap<String, Object>();
        ingameTimeObj.put("current", server.getIngameTime());
        ingameTimeObj.put("doDaylightCycle", server.getGamerules().get("doDaylightCycle"));
        ingameTimeObj.put("paused", TPS.isPaused());
        ingameTimeObj.put("mspt", TPS.getRecentMSPT());
        obj.put("ingameTime", ingameTimeObj);
        List players = server.getOnlinePlayers().stream().map(player -> {
            HashMap<String, Object> playerInfo = new HashMap<String, Object>();
            playerInfo.put("name", player.getName());
            playerInfo.put("uuid", player.getUUID());
            playerInfo.put("gamemode", player.getGameMode().getName());
            playerInfo.put("ping", player.getPing());
            return playerInfo;
        }).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        obj.put("onlinePlayers", players);
        this.sendResponse(res, obj);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        OPanelServer server = this.plugin.getServer();
        if (reqPath.substring(1).equals("motd")) {
            try {
                String motd = this.getRequestBody(req, String.class);
                if (motd == null || motd.trim().isEmpty()) {
                    this.sendResponse(res, 400);
                    return;
                }
                server.setMotd(Utils.base64ToString(motd));
                this.sendResponse(res, 200);
            }
            catch (IOException e) {
                this.plugin.logger.error("Failed to update MOTD: " + e.getMessage());
                this.sendResponse(res, 500);
            }
            catch (IllegalArgumentException e) {
                this.plugin.logger.error("Invalid Base64 encoding in MOTD: " + e.getMessage());
                this.sendResponse(res, 400);
            }
        } else {
            this.sendResponse(res, 400);
        }
    }
}

