/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.terminal;

import jakarta.websocket.CloseReason;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.opanel.OPanel;
import net.opanel.common.OPanelPlayer;
import net.opanel.deps.gson.Gson;
import net.opanel.deps.gson.JsonSyntaxException;
import net.opanel.logger.Loggable;
import net.opanel.terminal.ConsoleLog;
import net.opanel.terminal.LogListenerManager;
import net.opanel.terminal.TerminalPacket;
import net.opanel.utils.Utils;

@ServerEndpoint(value="/terminal", configurator=Configurator.class)
public class TerminalEndpoint {
    public static final String route = "/terminal";
    private final OPanel plugin;
    private final Loggable logger;
    private final LogListenerManager logListenerManager;
    private static final Set<Session> sessions = new HashSet<Session>();
    private static boolean hasLogListenerRegistered = false;

    public TerminalEndpoint(OPanel plugin) {
        this.plugin = plugin;
        this.logger = plugin.logger;
        this.logListenerManager = plugin.getLogListenerManager();
        if (!hasLogListenerRegistered) {
            this.logListenerManager.addListener(line -> this.broadcast(new TerminalPacket<ConsoleLog>("log", (ConsoleLog)line)));
            hasLogListenerRegistered = true;
        }
    }

    @OnOpen
    public void onOpen(Session session) {
    }

    @OnMessage
    public void onMessage(String message, Session session) throws IOException {
        try {
            Gson gson = new Gson();
            TerminalPacket packet = gson.fromJson(message, TerminalPacket.class);
            switch (packet.type) {
                case "auth": {
                    String token = (String)packet.data;
                    String hashedRealKey = this.plugin.getConfig().accessKey;
                    if (token != null && token.equals(Utils.md5(this.plugin.getConfig().salt + hashedRealKey))) {
                        sessions.add(session);
                        this.sendMessage(session, new TerminalPacket<List<ConsoleLog>>("init", this.logListenerManager.getRecentLogs()));
                        break;
                    }
                    session.close(new CloseReason(CloseReason.CloseCodes.VIOLATED_POLICY, "Unauthorized."));
                    break;
                }
                case "command": {
                    if (!sessions.contains(session)) {
                        session.close(new CloseReason(CloseReason.CloseCodes.VIOLATED_POLICY, "Unauthorized."));
                        return;
                    }
                    Object t = packet.data;
                    if (!(t instanceof String)) {
                        this.sendErrorMessage(session, "Unexpected type of data.");
                        return;
                    }
                    String command = (String)t;
                    this.plugin.getServer().sendServerCommand(command.replaceFirst("/", ""));
                    break;
                }
                case "autocomplete": {
                    if (!sessions.contains(session)) {
                        session.close(new CloseReason(CloseReason.CloseCodes.VIOLATED_POLICY, "Unauthorized."));
                        return;
                    }
                    Object t = packet.data;
                    if (!(t instanceof Number)) {
                        this.sendErrorMessage(session, "Unexpected type of data.");
                        return;
                    }
                    Number arg = (Number)t;
                    if (arg.equals(1.0)) {
                        this.sendMessage(session, new TerminalPacket<List<String>>("autocomplete", this.plugin.getServer().getCommands()));
                        return;
                    }
                    this.sendMessage(session, new TerminalPacket<List<String>>("autocomplete", this.plugin.getServer().getOnlinePlayers().stream().map(OPanelPlayer::getName).toList()));
                    break;
                }
                default: {
                    this.sendErrorMessage(session, "Unexpected type of packet.");
                }
            }
        }
        catch (JsonSyntaxException e) {
            this.sendErrorMessage(session, "Json syntax error: " + e.getMessage());
        }
    }

    @OnClose
    public void onClose(Session session) {
        sessions.remove(session);
    }

    private <T> void sendMessage(Session session, TerminalPacket<T> packet) {
        try {
            Gson gson = new Gson();
            session.getBasicRemote().sendObject(gson.toJson(packet));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void sendErrorMessage(Session session, String err) {
        this.sendMessage(session, new TerminalPacket<String>("error", err));
    }

    private <T> void broadcast(TerminalPacket<T> packet) {
        sessions.forEach(session -> this.sendMessage((Session)session, packet));
    }

    public static void closeAllSessions() throws IOException {
        for (Session session : sessions) {
            session.close(new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, "Server is stopping."));
        }
        sessions.clear();
    }

    public static class Configurator
    extends ServerEndpointConfig.Configurator {
        private static OPanel pluginInstance;

        public static void setPlugin(OPanel plugin) {
            pluginInstance = plugin;
        }

        @Override
        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            if (TerminalEndpoint.class.equals(endpointClass)) {
                if (pluginInstance == null) {
                    throw new IllegalStateException("Plugin instance has not been set in the EndpointConfigurator.");
                }
                return (T)new TerminalEndpoint(pluginInstance);
            }
            throw new InstantiationException("The provided endpoint class is not equal to TerminalEndpoint.");
        }
    }
}

