/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.config.OPanelConfiguration;
import net.opanel.utils.Utils;
import net.opanel.web.BaseServlet;

public class SecurityServlet
extends BaseServlet {
    public static final String route = "/api/security";

    public SecurityServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        RequestBodyType reqBody = this.getRequestBody(req, RequestBodyType.class);
        if (reqBody.currentKey == null || reqBody.newKey == null) {
            this.sendResponse(res, 400);
            return;
        }
        String currentKey = reqBody.currentKey;
        String newKey = reqBody.newKey;
        String realKey = this.plugin.getConfig().accessKey;
        if (!Utils.md5(currentKey).equals(realKey)) {
            this.sendResponse(res, 403);
            return;
        }
        OPanelConfiguration config = this.plugin.getConfig();
        config.accessKey = Utils.md5(newKey);
        this.plugin.setConfig(config);
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("token", Utils.md5(config.salt + config.accessKey));
        this.sendResponse(res, obj);
    }

    private class RequestBodyType {
        String currentKey;
        String newKey;

        private RequestBodyType(SecurityServlet securityServlet) {
        }
    }
}

