/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_21_5;

import com.mojang.logging.LogUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.opanel.OPanel;
import net.opanel.forge_1_21_5.ForgeServer;
import net.opanel.forge_1_21_5.LoggerImpl;
import net.opanel.forge_1_21_5.command.OPanelCommand;
import net.opanel.forge_1_21_5.config.Config;
import net.opanel.forge_1_21_5.config.ConfigManagerImpl;
import net.opanel.forge_1_21_5.terminal.LogListenerManagerImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.slf4j.Logger;

@Mod(value="opanel")
public class Main {
    public static final String MODID = "opanel";
    public static final Logger LOGGER = LogUtils.getLogger();
    public OPanel instance;
    private LogListenerManagerImpl logListenerAppender;

    public Main(FMLJavaModLoadingContext ctx) {
        ctx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.initLogListenerAppender();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.instance = new OPanel(new ConfigManagerImpl(), new LoggerImpl(LOGGER));
        this.instance.setLogListenerManager(this.logListenerAppender);
        OPanelCommand.instance = this.instance;
    }

    private void initLogListenerAppender() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        this.logListenerAppender = LogListenerManagerImpl.createAppender("LogListenerAppender", true);
        this.logListenerAppender.start();
        logger.addAppender((Appender)this.logListenerAppender);
    }

    private void disposeLogListenerAppender() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        logger.removeAppender((Appender)this.logListenerAppender);
        this.logListenerAppender.clearListeners();
    }

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        if (this.instance == null) {
            throw new NullPointerException("OPanel is not initialized.");
        }
        this.instance.setServer(new ForgeServer(event.getServer()));
        try {
            this.instance.getWebServer().start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        if (this.logListenerAppender != null) {
            this.disposeLogListenerAppender();
        }
        if (this.instance != null) {
            this.instance.stop();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent evnet) {
        if (this.instance == null) {
            throw new NullPointerException("OPanel is not initialized.");
        }
        this.instance.onTick();
    }
}

