/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.spigot_1_21;

import net.opanel.OPanel;
import net.opanel.deps.nbtapi.NBT;
import net.opanel.spigot_1_21.LoggerImpl;
import net.opanel.spigot_1_21.SpigotServer;
import net.opanel.spigot_1_21.command.OPanelCommand;
import net.opanel.spigot_1_21.config.ConfigManagerImpl;
import net.opanel.spigot_1_21.terminal.LogListenerManagerImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
extends JavaPlugin
implements Listener {
    public static final boolean isPaper;
    private static final Logger log;
    public final java.util.logging.Logger LOGGER = this.getLogger();
    public OPanel instance;
    private BukkitTask serverTickListener;
    private LogListenerManagerImpl logListenerAppender;

    public void onEnable() {
        if (!NBT.preloadApi()) {
            this.LOGGER.warning("Cannot start OPanel plugin: NBT-API is not initialized properly.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        LoggerImpl logger = new LoggerImpl(this.LOGGER);
        this.saveDefaultConfig();
        this.instance = new OPanel(new ConfigManagerImpl(this.getConfig()), logger);
        this.initLogListenerAppender();
        this.initServerTickListener();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("opanel").setExecutor((CommandExecutor)new OPanelCommand(this.instance));
    }

    public void onDisable() {
        if (this.logListenerAppender != null) {
            this.disposeLogListenerAppender();
        }
        if (this.serverTickListener != null) {
            this.serverTickListener.cancel();
        }
        if (this.instance != null) {
            this.instance.stop();
        }
    }

    private void initLogListenerAppender() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        this.logListenerAppender = LogListenerManagerImpl.createAppender("LogListenerAppender", true);
        this.logListenerAppender.start();
        logger.addAppender((Appender)this.logListenerAppender);
        this.instance.setLogListenerManager(this.logListenerAppender);
    }

    private void disposeLogListenerAppender() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        logger.removeAppender((Appender)this.logListenerAppender);
        this.logListenerAppender.clearListeners();
    }

    private void initServerTickListener() {
        this.serverTickListener = Bukkit.getScheduler().runTaskTimer((Plugin)this, this.instance::onTick, 0L, 1L);
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
        this.instance.setServer(new SpigotServer(this, this.getServer()));
        try {
            this.instance.getWebServer().start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runTask(Runnable task) {
        Bukkit.getScheduler().runTask((Plugin)this, task);
    }

    static {
        boolean _isPaper;
        log = LoggerFactory.getLogger(Main.class);
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            _isPaper = true;
        }
        catch (ClassNotFoundException e) {
            _isPaper = false;
        }
        isPaper = _isPaper;
    }
}

