/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.web;

import jakarta.servlet.DispatcherType;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.EnumSet;
import net.opanel.OPanel;
import net.opanel.api.AuthServlet;
import net.opanel.api.ControlServlet;
import net.opanel.api.GamerulesServlet;
import net.opanel.api.IconServlet;
import net.opanel.api.InfoServlet;
import net.opanel.api.LogsServlet;
import net.opanel.api.MonitorServlet;
import net.opanel.api.PlayersServlet;
import net.opanel.api.SavesServlet;
import net.opanel.api.SecurityServlet;
import net.opanel.api.WhitelistServlet;
import net.opanel.terminal.TerminalEndpoint;
import net.opanel.web.StaticFileServlet;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;

public class WebServer {
    public final int PORT;
    private final OPanel plugin;
    private Server server;

    public WebServer(OPanel plugin) {
        this.plugin = plugin;
        this.PORT = plugin.getConfig().webServerPort;
    }

    public void start() throws Exception {
        this.server = new Server(this.PORT);
        ServletContextHandler ctx = new ServletContextHandler(1);
        ctx.setContextPath("/");
        this.server.setHandler(ctx);
        FilterHolder cors = new FilterHolder(new CrossOriginFilter());
        cors.setInitParameter("allowedOrigins", "http://localhost:3001");
        cors.setInitParameter("allowedMethods", "GET,POST,DELETE,HEAD,OPTIONS");
        cors.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,X-Credential-Token");
        ctx.addFilter(cors, "/*", EnumSet.of(DispatcherType.REQUEST));
        TerminalEndpoint.Configurator.setPlugin(this.plugin);
        JakartaWebSocketServletContainerInitializer.configure(ctx, (servletContext, serverContainer) -> {
            serverContainer.setDefaultMaxSessionIdleTimeout(-1L);
            try {
                serverContainer.addEndpoint(ServerEndpointConfig.Builder.create(TerminalEndpoint.class, "/terminal").configurator(new TerminalEndpoint.Configurator()).build());
            }
            catch (DeploymentException e) {
                e.printStackTrace();
            }
        });
        ctx.addServlet(new ServletHolder(new AuthServlet(this.plugin)), "/api/auth");
        ctx.addServlet(new ServletHolder(new SecurityServlet(this.plugin)), "/api/security");
        ctx.addServlet(new ServletHolder(new InfoServlet(this.plugin)), "/api/info/*");
        ctx.addServlet(new ServletHolder(new ControlServlet(this.plugin)), "/api/control/*");
        ctx.addServlet(new ServletHolder(new IconServlet(this.plugin)), "/api/icon");
        ctx.addServlet(new ServletHolder(new SavesServlet(this.plugin)), "/api/saves/*");
        ctx.addServlet(new ServletHolder(new PlayersServlet(this.plugin)), "/api/players/*");
        ctx.addServlet(new ServletHolder(new WhitelistServlet(this.plugin)), "/api/whitelist/*");
        ctx.addServlet(new ServletHolder(new MonitorServlet(this.plugin)), "/api/monitor");
        ctx.addServlet(new ServletHolder(new GamerulesServlet(this.plugin)), "/api/gamerules");
        ctx.addServlet(new ServletHolder(new LogsServlet(this.plugin)), "/api/logs/*");
        ctx.addServlet(new ServletHolder(new StaticFileServlet(this.plugin)), "/");
        this.server.start();
        this.plugin.logger.info("Web server is ready on port " + this.PORT);
        this.server.addEventListener(new LifeCycle.Listener(this){

            @Override
            public void lifeCycleStopping(LifeCycle event) {
                try {
                    TerminalEndpoint.closeAllSessions();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void stop() throws Exception {
        this.server.stop();
        this.plugin.logger.info("Web server is stopped.");
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public String getJettyVersion() {
        return Jetty.VERSION;
    }
}

