/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_21_5;

import com.mojang.authlib.GameProfile;
import java.util.Date;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.world.level.GameType;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;

public class ForgePlayer
implements OPanelPlayer {
    private final ServerPlayer player;
    private final PlayerList playerManager;
    private final GameProfile profile;

    public ForgePlayer(ServerPlayer player) {
        this.player = player;
        this.playerManager = player.getServer().getPlayerList();
        this.profile = player.getGameProfile();
    }

    @Override
    public String getName() {
        if (this.player == null) {
            return "";
        }
        return this.player.getName().getString();
    }

    @Override
    public String getUUID() {
        if (this.player == null) {
            return null;
        }
        return this.player.getStringUUID();
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public boolean isOp() {
        if (this.player == null) {
            return false;
        }
        return this.playerManager.isOp(this.profile);
    }

    @Override
    public boolean isBanned() {
        return false;
    }

    @Override
    public OPanelGameMode getGameMode() {
        if (this.player == null) {
            return null;
        }
        GameType gamemode = this.player.gameMode();
        switch (gamemode) {
            case ADVENTURE: {
                return OPanelGameMode.ADVENTURE;
            }
            case SURVIVAL: {
                return OPanelGameMode.SURVIVAL;
            }
            case CREATIVE: {
                return OPanelGameMode.CREATIVE;
            }
            case SPECTATOR: {
                return OPanelGameMode.SPECTATOR;
            }
        }
        return null;
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        if (this.player == null) {
            return;
        }
        switch (gamemode) {
            case ADVENTURE: {
                this.player.setGameMode(GameType.ADVENTURE);
                break;
            }
            case SURVIVAL: {
                this.player.setGameMode(GameType.SURVIVAL);
                break;
            }
            case CREATIVE: {
                this.player.setGameMode(GameType.CREATIVE);
                break;
            }
            case SPECTATOR: {
                this.player.setGameMode(GameType.SPECTATOR);
            }
        }
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.playerManager.op(this.profile);
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.playerManager.deop(this.profile);
    }

    @Override
    public void kick(String reason) {
        this.player.connection.disconnect(Component.nullToEmpty((String)reason));
    }

    @Override
    public void ban(String reason) {
        UserBanList bannedList = this.playerManager.getBans();
        UserBanListEntry entry = new UserBanListEntry(this.profile, new Date(), null, null, reason);
        bannedList.add((StoredUserEntry)entry);
        this.kick(reason);
    }

    @Override
    public String getBanReason() {
        return null;
    }

    @Override
    public void pardon() {
    }

    @Override
    public int getPing() {
        return this.player.connection.latency();
    }
}

