/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Stream;
import java.util.zip.ZipException;
import net.opanel.OPanel;
import net.opanel.ServerType;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.utils.Utils;
import net.opanel.utils.ZipUtility;
import net.opanel.web.BaseServlet;

public class SavesServlet
extends BaseServlet {
    public static final String route = "/api/saves/*";
    private static final MultipartConfigElement multipartConfig = new MultipartConfigElement(OPanel.TMP_DIR_PATH.toString(), -1L, -1L, 0x100000);

    public SavesServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        OPanelServer server = this.plugin.getServer();
        if (reqPath != null && !reqPath.equals("/")) {
            String saveName = reqPath.substring(1);
            OPanelSave save = server.getSave(saveName);
            if (save == null) {
                this.sendResponse(res, 404);
                return;
            }
            if (save.isRunning()) {
                server.saveAll();
            }
            Path savePath = save.getPath();
            Path zipPath = OPanel.TMP_DIR_PATH.resolve(save.getName() + ".zip");
            if (server.getServerType() == ServerType.BUKKIT) {
                Utils.copyDirectoryRecursively(Paths.get("", new String[0]).resolve(saveName + "_nether/DIM-1"), savePath.resolve("DIM-1"));
                Utils.copyDirectoryRecursively(Paths.get("", new String[0]).resolve(saveName + "_the_end/DIM1"), savePath.resolve("DIM1"));
            }
            try {
                ZipUtility.zip(savePath, zipPath);
                this.sendContentResponse(res, Utils.readFile(zipPath), "application/octet-stream");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.sendResponse(res, 500);
            }
            Files.delete(zipPath);
            if (server.getServerType() == ServerType.BUKKIT) {
                Utils.deleteDirectoryRecursively(savePath.resolve("DIM-1"));
                Utils.deleteDirectoryRecursively(savePath.resolve("DIM1"));
            }
            return;
        }
        HashMap<String, Object> obj = new HashMap<String, Object>();
        ArrayList saves = new ArrayList();
        for (OPanelSave save : server.getSaves()) {
            HashMap<String, Object> saveInfo = new HashMap<String, Object>();
            saveInfo.put("name", save.getName());
            saveInfo.put("displayName", save.getDisplayName());
            saveInfo.put("path", save.getPath().toString());
            saveInfo.put("size", save.getSize());
            saveInfo.put("isRunning", save.isRunning());
            saveInfo.put("isCurrent", save.isCurrent());
            saveInfo.put("defaultGameMode", save.getDefaultGameMode().getName());
            saves.add(saveInfo);
        }
        obj.put("saves", saves);
        this.sendResponse(res, obj);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        OPanelServer server = this.plugin.getServer();
        if (reqPath == null || reqPath.equals("/") || !reqPath.startsWith("/")) {
            req.setCharacterEncoding("utf-8");
            req.setAttribute("org.eclipse.jetty.multipartConfig", multipartConfig);
            try {
                Part filePart = req.getPart("file");
                if (filePart == null || filePart.getSize() <= 0L) {
                    this.sendResponse(res, 400);
                    return;
                }
                String fileName = filePart.getSubmittedFileName();
                if (!fileName.endsWith(".zip")) {
                    this.sendResponse(res, 400);
                    return;
                }
                Path targetPath = Paths.get("", new String[0]).resolve(fileName.replaceAll(".zip", ""));
                if (Files.exists(targetPath, new LinkOption[0])) {
                    this.sendResponse(res, 409);
                    return;
                }
                Path filePath = OPanel.TMP_DIR_PATH.resolve(fileName);
                try (InputStream is = filePart.getInputStream();){
                    Files.copy(is, filePath, StandardCopyOption.REPLACE_EXISTING);
                }
                ZipUtility.unzip(filePath, targetPath);
                Files.delete(filePath);
                if (!Files.exists(targetPath.resolve("level.dat"), new LinkOption[0])) {
                    Path folderInside = targetPath.resolve(targetPath.getFileName()).toAbsolutePath();
                    if (!Files.exists(folderInside, new LinkOption[0])) {
                        Utils.deleteDirectoryRecursively(targetPath);
                        this.sendResponse(res, 400);
                        return;
                    }
                    try (Stream<Path> stream = Files.list(folderInside);){
                        stream.forEach(path -> {
                            try {
                                Utils.copyDirectoryRecursively(path, targetPath.resolve(path.getFileName()));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        });
                    }
                    Utils.deleteDirectoryRecursively(folderInside);
                }
                if (!Files.exists(targetPath.resolve("level.dat"), new LinkOption[0])) {
                    Utils.deleteDirectoryRecursively(targetPath);
                    this.sendResponse(res, 400);
                    return;
                }
                this.sendResponse(res, 200);
            }
            catch (ZipException e) {
                this.plugin.logger.warn("An illegal save zip is detected! This may cause a zip slip, so it is blocked from unzipping to the server.");
                this.sendResponse(res, 403);
                Utils.clearDirectoryRecursively(OPanel.TMP_DIR_PATH);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.sendResponse(res, 500);
            }
        } else {
            String saveName = reqPath.substring(1);
            SaveEditRequestBodyType reqBody = this.getRequestBody(req, SaveEditRequestBodyType.class);
            try {
                OPanelSave save = server.getSave(saveName);
                save.setDisplayName(reqBody.displayName);
                save.setDefaultGameMode(OPanelGameMode.fromString(reqBody.defaultGameMode));
                this.sendResponse(res, 200);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.sendResponse(res, 500);
            }
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        OPanelServer server = this.plugin.getServer();
        if (reqPath == null || reqPath.equals("/") || !reqPath.startsWith("/")) {
            this.sendResponse(res, 400);
            return;
        }
        String saveName = reqPath.substring(1);
        OPanelSave save = server.getSave(saveName);
        if (save.isRunning() || save.isCurrent()) {
            this.sendResponse(res, 403);
            return;
        }
        try {
            save.delete();
            this.sendResponse(res, 200);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(res, 500, e.getMessage());
        }
    }

    private static class SaveEditRequestBodyType {
        String displayName;
        String defaultGameMode;

        private SaveEditRequestBodyType() {
        }
    }
}

