/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_20_6;

import com.google.common.reflect.TypeToken;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.server.players.UserWhiteListEntry;
import net.opanel.common.OPanelWhitelist;
import net.opanel.deps.gson.Gson;
import net.opanel.deps.gson.GsonBuilder;
import net.opanel.utils.Utils;

public class ForgeWhitelist
implements OPanelWhitelist {
    private final UserWhiteList whitelist;
    private final Path whitelistPath;

    public ForgeWhitelist(UserWhiteList whitelist) {
        this.whitelist = whitelist;
        this.whitelistPath = whitelist.getFile().toPath();
    }

    @Override
    public List<String> getNames() throws IOException {
        this.whitelist.load();
        return Arrays.asList(this.whitelist.getUserList());
    }

    @Override
    public List<OPanelWhitelist.OPanelWhitelistEntry> getEntries() throws IOException {
        String jsonStr = Utils.readTextFile(this.whitelistPath);
        Type listType = new TypeToken<List<OPanelWhitelist.OPanelWhitelistEntry>>(){}.getType();
        Gson gson = new Gson();
        return (List)gson.fromJson(jsonStr, listType);
    }

    @Override
    public void write(List<OPanelWhitelist.OPanelWhitelistEntry> entries) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Utils.writeTextFile(this.whitelistPath, gson.toJson(entries));
        this.whitelist.load();
    }

    @Override
    public void add(OPanelWhitelist.OPanelWhitelistEntry entry) throws IOException {
        if (this.getNames().contains(entry.name)) {
            return;
        }
        GameProfile profile = new GameProfile(UUID.fromString(entry.uuid), entry.name);
        this.whitelist.add((StoredUserEntry)new UserWhiteListEntry(profile));
        this.whitelist.save();
    }

    @Override
    public void remove(OPanelWhitelist.OPanelWhitelistEntry entry) throws IOException {
        if (!this.getNames().contains(entry.name)) {
            return;
        }
        GameProfile profile = new GameProfile(UUID.fromString(entry.uuid), entry.name);
        this.whitelist.remove((StoredUserEntry)new UserWhiteListEntry(profile));
        this.whitelist.save();
    }
}

