/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.utils.Utils;
import net.opanel.web.BaseServlet;
import net.opanel.web.JwtManager;

public class AuthServlet
extends BaseServlet {
    public static final String route = "/api/auth";

    public AuthServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        RequestBodyType reqBody = this.getRequestBody(req, RequestBodyType.class);
        if (reqBody.accessKey == null) {
            this.sendResponse(res, 400);
            return;
        }
        String submittedKey = reqBody.accessKey;
        String hashedRealKey = this.plugin.getConfig().accessKey;
        String hashedSubmittedKey = Utils.md5(submittedKey);
        if (hashedSubmittedKey.equals(hashedRealKey)) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("token", JwtManager.generateToken(hashedRealKey, this.plugin.getConfig().salt));
            this.sendResponse(res, obj);
        } else {
            this.sendResponse(res, 401);
        }
    }

    private class RequestBodyType {
        String accessKey;

        private RequestBodyType() {
        }
    }
}

