/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.UnknownHostException;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.common.OPanelServer;
import net.opanel.utils.Utils;
import net.opanel.web.BaseServlet;

public class BannedIpsServlet
extends BaseServlet {
    public static final String route = "/api/banned-ips/*";

    public BannedIpsServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        OPanelServer server = this.plugin.getServer();
        if (reqPath != null && !reqPath.equals("/")) {
            this.sendResponse(res, 400);
            return;
        }
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("bannedIps", server.getBannedIps());
        this.sendResponse(res, obj);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        OPanelServer server = this.plugin.getServer();
        if (reqPath == null || reqPath.equals("/")) {
            this.sendResponse(res, 400);
            return;
        }
        String ip = req.getParameter("ip");
        if (ip == null || !Utils.validateIpv4Address(ip)) {
            this.sendResponse(res, 400);
            return;
        }
        try {
            switch (reqPath.substring(1)) {
                case "add": {
                    server.banIp(ip);
                    break;
                }
                case "remove": {
                    server.pardonIp(ip);
                }
            }
            this.sendResponse(res, 200);
        }
        catch (UnknownHostException e) {
            this.sendResponse(res, 400);
        }
    }
}

