/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.spigot_1_21;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;
import net.opanel.deps.nbtapi.NBT;
import net.opanel.deps.nbtapi.iface.ReadWriteNBT;
import net.opanel.spigot_1_21.Main;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.profile.PlayerProfile;

public class SpigotOfflinePlayer
implements OPanelPlayer {
    private final Main plugin;
    private final OfflinePlayer player;
    private final Server server;
    private final Path playerDataPath;
    private final PlayerProfile profile;

    public SpigotOfflinePlayer(Main plugin, Server server, OfflinePlayer player) {
        this.plugin = plugin;
        this.server = server;
        this.player = player;
        if (player.isOnline()) {
            throw new IllegalStateException("The player is offline.");
        }
        String uuid = player.getUniqueId().toString();
        this.playerDataPath = ((World)server.getWorlds().getFirst()).getWorldFolder().toPath().resolve("playerdata/" + uuid + ".dat");
        if (!Files.exists(this.playerDataPath, new LinkOption[0])) {
            throw new NullPointerException("Player data file for UUID " + uuid + " unavailable.");
        }
        this.profile = player.getPlayerProfile();
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public String getUUID() {
        return this.player.getUniqueId().toString();
    }

    @Override
    public boolean isOnline() {
        return false;
    }

    @Override
    public boolean isOp() {
        return this.player.isOp();
    }

    @Override
    public boolean isBanned() {
        return this.player.isBanned();
    }

    @Override
    public OPanelGameMode getGameMode() {
        try {
            ReadWriteNBT nbt = NBT.readFile(this.playerDataPath.toFile());
            int gamemode = nbt.getInteger("playerGameType");
            switch (gamemode) {
                case 2: {
                    return OPanelGameMode.ADVENTURE;
                }
                case 0: {
                    return OPanelGameMode.SURVIVAL;
                }
                case 1: {
                    return OPanelGameMode.CREATIVE;
                }
                case 3: {
                    return OPanelGameMode.SPECTATOR;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        try {
            ReadWriteNBT nbt = NBT.readFile(this.playerDataPath.toFile());
            switch (gamemode) {
                case ADVENTURE: {
                    nbt.setInteger("playerGameType", 2);
                    break;
                }
                case SURVIVAL: {
                    nbt.setInteger("playerGameType", 0);
                    break;
                }
                case CREATIVE: {
                    nbt.setInteger("playerGameType", 1);
                    break;
                }
                case SPECTATOR: {
                    nbt.setInteger("playerGameType", 3);
                }
            }
            NBT.writeFile(this.playerDataPath.toFile(), nbt);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.plugin.runTask(() -> this.player.setOp(true));
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.plugin.runTask(() -> this.player.setOp(false));
    }

    @Override
    public void kick(String reason) {
        throw new IllegalStateException("The player is offline.");
    }

    @Override
    public void ban(String reason) {
        if (this.isBanned()) {
            return;
        }
        this.plugin.runTask(() -> this.player.ban(reason, (Date)null, null));
    }

    @Override
    public String getBanReason() {
        if (!this.isBanned()) {
            return null;
        }
        BanList banList = this.server.getBanList(BanList.Type.PROFILE);
        BanEntry banEntry = banList.getBanEntry((Object)this.profile);
        if (banEntry == null) {
            return null;
        }
        return banEntry.getReason();
    }

    @Override
    public void pardon() {
        if (!this.isBanned()) {
            return;
        }
        BanList banList = this.server.getBanList(BanList.Type.PROFILE);
        this.plugin.runTask(() -> banList.pardon((Object)this.profile));
    }

    @Override
    public int getPing() {
        throw new IllegalStateException("The player is offline.");
    }
}

