/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.AbstractJwk;
import io.jsonwebtoken.impl.security.AsymmetricJwkFactory;
import io.jsonwebtoken.impl.security.EcPrivateJwkFactory;
import io.jsonwebtoken.impl.security.EcPublicJwkFactory;
import io.jsonwebtoken.impl.security.FamilyJwkFactory;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.JwkFactory;
import io.jsonwebtoken.impl.security.OctetPrivateJwkFactory;
import io.jsonwebtoken.impl.security.OctetPublicJwkFactory;
import io.jsonwebtoken.impl.security.RsaPrivateJwkFactory;
import io.jsonwebtoken.impl.security.RsaPublicJwkFactory;
import io.jsonwebtoken.impl.security.SecretJwkFactory;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.UnsupportedKeyException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;

class DispatchingJwkFactory
implements JwkFactory<Key, Jwk<Key>> {
    private static final Collection<FamilyJwkFactory<Key, ?>> DEFAULT_FACTORIES = DispatchingJwkFactory.createDefaultFactories();
    static final JwkFactory<Key, Jwk<Key>> DEFAULT_INSTANCE = new DispatchingJwkFactory();
    private final Collection<FamilyJwkFactory<Key, ?>> factories;

    private static Collection<FamilyJwkFactory<Key, ?>> createDefaultFactories() {
        ArrayList families = new ArrayList(3);
        families.add(new SecretJwkFactory());
        families.add(new AsymmetricJwkFactory(EcPublicJwkFactory.INSTANCE, new EcPrivateJwkFactory()));
        families.add(new AsymmetricJwkFactory(RsaPublicJwkFactory.INSTANCE, new RsaPrivateJwkFactory()));
        families.add(new AsymmetricJwkFactory(OctetPublicJwkFactory.INSTANCE, new OctetPrivateJwkFactory()));
        return families;
    }

    DispatchingJwkFactory() {
        this(DEFAULT_FACTORIES);
    }

    DispatchingJwkFactory(Collection<? extends FamilyJwkFactory<?, ?>> factories) {
        Assert.notEmpty(factories, "FamilyJwkFactory collection cannot be null or empty.");
        this.factories = new ArrayList(factories.size());
        for (FamilyJwkFactory<?, ?> factory : factories) {
            Assert.hasText(factory.getId(), "FamilyJwkFactory.getFactoryId() cannot return null or empty.");
            this.factories.add(factory);
        }
    }

    @Override
    public JwkContext<Key> newContext(JwkContext<?> src, Key key) {
        Assert.notNull(src, "JwkContext cannot be null.");
        String kty = src.getType();
        DispatchingJwkFactory.assertKeyOrKeyType(key, kty);
        for (FamilyJwkFactory<Key, ?> factory : this.factories) {
            if (!factory.supports(key) && !factory.supports(src)) continue;
            JwkContext<Key> ctx = factory.newContext(src, key);
            return Assert.notNull(ctx, "FamilyJwkFactory implementation cannot return null JwkContexts.");
        }
        throw DispatchingJwkFactory.noFamily(key, kty);
    }

    private static void assertKeyOrKeyType(Key key, String kty) {
        if (key == null && !Strings.hasText(kty)) {
            String msg = "Either a Key instance or a " + AbstractJwk.KTY + " value is required to create a JWK.";
            throw new InvalidKeyException(msg);
        }
    }

    @Override
    public Jwk<Key> createJwk(JwkContext<Key> ctx) {
        Assert.notNull(ctx, "JwkContext cannot be null.");
        Key key = ctx.getKey();
        String kty = Strings.clean(ctx.getType());
        DispatchingJwkFactory.assertKeyOrKeyType(key, kty);
        for (FamilyJwkFactory<Key, Key> familyJwkFactory : this.factories) {
            if (!familyJwkFactory.supports(ctx)) continue;
            String algFamilyId = Assert.hasText(familyJwkFactory.getId(), "factory id cannot be null or empty.");
            if (kty == null) {
                ctx.setType(algFamilyId);
            }
            return familyJwkFactory.createJwk(ctx);
        }
        throw DispatchingJwkFactory.noFamily(key, kty);
    }

    private static UnsupportedKeyException noFamily(Key key, String kty) {
        String reason = key != null ? "key of type " + key.getClass().getName() : "kty value '" + kty + "'";
        String msg = "Unable to create JWK for unrecognized " + reason + ": there is no known JWK Factory capable of creating JWKs for this key type.";
        return new UnsupportedKeyException(msg);
    }
}

