/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_21_8;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.LevelResource;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;

public class ForgeOfflinePlayer
implements OPanelPlayer {
    private final PlayerList playerManager;
    private final Path playerDataPath;
    private final GameProfile profile;
    private final UUID uuid;

    public ForgeOfflinePlayer(MinecraftServer server, UUID uuid) {
        this.playerManager = server.getPlayerList();
        this.playerDataPath = server.getWorldPath(LevelResource.PLAYER_DATA_DIR).resolve(String.valueOf(uuid) + ".dat");
        GameProfileCache profileCache = server.getProfileCache();
        this.uuid = uuid;
        if (!Files.exists(this.playerDataPath, new LinkOption[0])) {
            throw new NullPointerException("Player data file for UUID " + String.valueOf(uuid) + " unavailable.");
        }
        if (profileCache == null) {
            throw new NullPointerException("Cannot get player profile cache.");
        }
        ServerPlayer serverPlayer = this.playerManager.getPlayer(uuid);
        if (serverPlayer != null && !serverPlayer.hasDisconnected()) {
            throw new IllegalStateException("The provided player is online, please use ForgePlayer class instead.");
        }
        Optional profileOpt = profileCache.get(uuid);
        if (profileOpt.isEmpty()) {
            throw new NullPointerException("Cannot get the game profile of the provided player.");
        }
        this.profile = (GameProfile)profileOpt.get();
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public String getUUID() {
        return this.uuid.toString();
    }

    @Override
    public boolean isOnline() {
        return false;
    }

    @Override
    public boolean isOp() {
        return this.playerManager.isOp(this.profile);
    }

    @Override
    public boolean isBanned() {
        return this.playerManager.getBans().isBanned(this.profile);
    }

    @Override
    public OPanelGameMode getGameMode() {
        try {
            CompoundTag nbt = NbtIo.readCompressed((Path)this.playerDataPath, (NbtAccounter)NbtAccounter.create((long)0x200000L));
            int gamemodeId = nbt.getIntOr("playerGameType", 0);
            GameType gamemode = GameType.byId((int)gamemodeId);
            switch (gamemode) {
                case ADVENTURE: {
                    return OPanelGameMode.ADVENTURE;
                }
                case SURVIVAL: {
                    return OPanelGameMode.SURVIVAL;
                }
                case CREATIVE: {
                    return OPanelGameMode.CREATIVE;
                }
                case SPECTATOR: {
                    return OPanelGameMode.SPECTATOR;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        try {
            CompoundTag nbt = NbtIo.readCompressed((Path)this.playerDataPath, (NbtAccounter)NbtAccounter.create((long)0x200000L));
            switch (gamemode) {
                case ADVENTURE: {
                    nbt.putInt("playerGameType", 2);
                    break;
                }
                case SURVIVAL: {
                    nbt.putInt("playerGameType", 0);
                    break;
                }
                case CREATIVE: {
                    nbt.putInt("playerGameType", 1);
                    break;
                }
                case SPECTATOR: {
                    nbt.putInt("playerGameType", 3);
                }
            }
            NbtIo.writeCompressed((CompoundTag)nbt, (Path)this.playerDataPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.playerManager.op(this.profile);
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.playerManager.deop(this.profile);
    }

    @Override
    public void kick(String reason) {
        throw new IllegalStateException("The player is offline.");
    }

    @Override
    public void ban(String reason) {
        if (this.isBanned()) {
            return;
        }
        UserBanList bannedList = this.playerManager.getBans();
        UserBanListEntry entry = new UserBanListEntry(this.profile, new Date(), null, null, reason);
        bannedList.add((StoredUserEntry)entry);
    }

    @Override
    public String getBanReason() {
        if (!this.isBanned()) {
            return null;
        }
        UserBanListEntry banEntry = (UserBanListEntry)this.playerManager.getBans().get((Object)this.profile);
        if (banEntry == null) {
            return null;
        }
        return banEntry.getReason();
    }

    @Override
    public void pardon() {
        if (!this.isBanned()) {
            return;
        }
        this.playerManager.getBans().remove((Object)this.profile);
    }

    @Override
    public int getPing() {
        throw new IllegalStateException("The player is offline.");
    }
}

