/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.deps.oshi.hardware.platform.unix.aix;

import com.sun.jna.platform.unix.aix.Perfstat;
import java.util.List;
import java.util.function.Supplier;
import net.opanel.deps.oshi.annotation.concurrent.ThreadSafe;
import net.opanel.deps.oshi.driver.unix.aix.Lscfg;
import net.opanel.deps.oshi.driver.unix.aix.perfstat.PerfstatDisk;
import net.opanel.deps.oshi.hardware.CentralProcessor;
import net.opanel.deps.oshi.hardware.ComputerSystem;
import net.opanel.deps.oshi.hardware.Display;
import net.opanel.deps.oshi.hardware.GlobalMemory;
import net.opanel.deps.oshi.hardware.GraphicsCard;
import net.opanel.deps.oshi.hardware.HWDiskStore;
import net.opanel.deps.oshi.hardware.NetworkIF;
import net.opanel.deps.oshi.hardware.PowerSource;
import net.opanel.deps.oshi.hardware.Sensors;
import net.opanel.deps.oshi.hardware.SoundCard;
import net.opanel.deps.oshi.hardware.UsbDevice;
import net.opanel.deps.oshi.hardware.common.AbstractHardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.unix.UnixDisplay;
import net.opanel.deps.oshi.hardware.platform.unix.aix.AixCentralProcessor;
import net.opanel.deps.oshi.hardware.platform.unix.aix.AixComputerSystem;
import net.opanel.deps.oshi.hardware.platform.unix.aix.AixGlobalMemory;
import net.opanel.deps.oshi.hardware.platform.unix.aix.AixGraphicsCard;
import net.opanel.deps.oshi.hardware.platform.unix.aix.AixHWDiskStore;
import net.opanel.deps.oshi.hardware.platform.unix.aix.AixNetworkIF;
import net.opanel.deps.oshi.hardware.platform.unix.aix.AixPowerSource;
import net.opanel.deps.oshi.hardware.platform.unix.aix.AixSensors;
import net.opanel.deps.oshi.hardware.platform.unix.aix.AixSoundCard;
import net.opanel.deps.oshi.hardware.platform.unix.aix.AixUsbDevice;
import net.opanel.deps.oshi.util.Memoizer;

@ThreadSafe
public final class AixHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    private final Supplier<List<String>> lscfg = Memoizer.memoize(Lscfg::queryAllDevices, Memoizer.defaultExpiration());
    private final Supplier<Perfstat.perfstat_disk_t[]> diskStats = Memoizer.memoize(PerfstatDisk::queryDiskStats, Memoizer.defaultExpiration());

    @Override
    public ComputerSystem createComputerSystem() {
        return new AixComputerSystem(this.lscfg);
    }

    @Override
    public GlobalMemory createMemory() {
        return new AixGlobalMemory(this.lscfg);
    }

    @Override
    public CentralProcessor createProcessor() {
        return new AixCentralProcessor();
    }

    @Override
    public Sensors createSensors() {
        return new AixSensors(this.lscfg);
    }

    @Override
    public List<PowerSource> getPowerSources() {
        return AixPowerSource.getPowerSources();
    }

    @Override
    public List<HWDiskStore> getDiskStores() {
        return AixHWDiskStore.getDisks(this.diskStats);
    }

    @Override
    public List<Display> getDisplays() {
        return UnixDisplay.getDisplays();
    }

    @Override
    public List<NetworkIF> getNetworkIFs(boolean includeLocalInterfaces) {
        return AixNetworkIF.getNetworks(includeLocalInterfaces);
    }

    @Override
    public List<UsbDevice> getUsbDevices(boolean tree) {
        return AixUsbDevice.getUsbDevices(tree, this.lscfg);
    }

    @Override
    public List<SoundCard> getSoundCards() {
        return AixSoundCard.getSoundCards(this.lscfg);
    }

    @Override
    public List<GraphicsCard> getGraphicsCards() {
        return AixGraphicsCard.getGraphicsCards(this.lscfg);
    }
}

