/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.DefaultOctetPublicJwk;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.OctetJwkFactory;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.OctetPublicJwk;
import java.security.PublicKey;

public class OctetPublicJwkFactory
extends OctetJwkFactory<PublicKey, OctetPublicJwk<PublicKey>> {
    static final OctetPublicJwkFactory INSTANCE = new OctetPublicJwkFactory();

    OctetPublicJwkFactory() {
        super(PublicKey.class, DefaultOctetPublicJwk.PARAMS);
    }

    @Override
    protected OctetPublicJwk<PublicKey> createJwkFromKey(JwkContext<PublicKey> ctx) {
        PublicKey key = Assert.notNull(ctx.getKey(), "PublicKey cannot be null.");
        EdwardsCurve crv = EdwardsCurve.forKey(key);
        byte[] x = crv.getKeyMaterial(key);
        Assert.notEmpty(x, "Edwards PublicKey 'x' value cannot be null or empty.");
        OctetPublicJwkFactory.put(ctx, DefaultOctetPublicJwk.CRV, crv.getId());
        OctetPublicJwkFactory.put(ctx, DefaultOctetPublicJwk.X, x);
        return new DefaultOctetPublicJwk<PublicKey>(ctx);
    }

    @Override
    protected OctetPublicJwk<PublicKey> createJwkFromValues(JwkContext<PublicKey> ctx) {
        RequiredParameterReader reader = new RequiredParameterReader(ctx);
        EdwardsCurve curve = OctetPublicJwkFactory.getCurve(reader);
        byte[] x = reader.get(DefaultOctetPublicJwk.X);
        PublicKey key = curve.toPublicKey(x, ctx.getProvider());
        ctx.setKey(key);
        return new DefaultOctetPublicJwk<PublicKey>(ctx);
    }
}

