/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.PrivateECKey;
import io.jsonwebtoken.impl.security.ProvidedKeyBuilder;
import io.jsonwebtoken.impl.security.ProviderPrivateKey;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.PrivateKeyBuilder;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;

public class ProvidedPrivateKeyBuilder
extends ProvidedKeyBuilder<PrivateKey, PrivateKeyBuilder>
implements PrivateKeyBuilder {
    private PublicKey publicKey;

    ProvidedPrivateKeyBuilder(PrivateKey key) {
        super(key);
    }

    @Override
    public PrivateKeyBuilder publicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Override
    public PrivateKey doBuild() {
        PrivateKey key = (PrivateKey)this.key;
        String privAlg = Strings.clean(((PrivateKey)this.key).getAlgorithm());
        if (!(key instanceof ECKey) && ("EC".equalsIgnoreCase(privAlg) || "ECDSA".equalsIgnoreCase(privAlg)) && this.publicKey instanceof ECKey) {
            key = new PrivateECKey(key, ((ECKey)((Object)this.publicKey)).getParams());
        }
        return this.provider != null ? new ProviderPrivateKey(this.provider, key) : key;
    }
}

