/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.terminal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.opanel.OPanel;
import net.opanel.common.OPanelPlayer;
import net.opanel.deps.gson.Gson;
import net.opanel.deps.javalin.websocket.WsCloseContext;
import net.opanel.deps.javalin.websocket.WsConfig;
import net.opanel.deps.javalin.websocket.WsConnectContext;
import net.opanel.deps.javalin.websocket.WsMessageContext;
import net.opanel.terminal.ConsoleLog;
import net.opanel.terminal.LogListenerManager;
import net.opanel.terminal.TerminalPacket;
import net.opanel.web.JwtManager;
import org.eclipse.jetty.websocket.api.Session;

public class TerminalEndpoint {
    private final OPanel plugin;
    private final LogListenerManager logListenerManager;
    private static final Set<Session> sessions = Collections.synchronizedSet(new HashSet());
    private static final AtomicBoolean hasLogListenerRegistered = new AtomicBoolean(false);

    public TerminalEndpoint(WsConfig ws, OPanel plugin) {
        this.plugin = plugin;
        this.logListenerManager = plugin.getLogListenerManager();
        ws.onConnect(this::onConnect);
        ws.onMessage(this::onMessage);
        ws.onClose(this::onClose);
        if (hasLogListenerRegistered.compareAndSet(false, true)) {
            this.logListenerManager.addListener(log -> this.broadcast(new TerminalPacket<ConsoleLog>("log", (ConsoleLog)log)));
        }
    }

    public void onConnect(WsConnectContext ctx) {
    }

    public void onMessage(WsMessageContext ctx) throws IOException {
        TerminalPacket packet = ctx.messageAsClass(TerminalPacket.class);
        Session session = ctx.session;
        switch (packet.type) {
            case "auth": {
                String token = (String)packet.data;
                String hashedRealKey = this.plugin.getConfig().accessKey;
                if (token != null && JwtManager.verifyToken(token, hashedRealKey, this.plugin.getConfig().salt)) {
                    sessions.add(session);
                    ctx.send(new TerminalPacket<List<ConsoleLog>>("init", this.logListenerManager.getRecentLogs()));
                    break;
                }
                ctx.closeSession(1008, "Unauthorized.");
                break;
            }
            case "command": {
                if (!sessions.contains(session)) {
                    ctx.closeSession(1008, "Unauthorized.");
                    return;
                }
                if (packet.data instanceof String) {
                    String command = (String)packet.data;
                    if (command.startsWith("/")) {
                        command = command.replace("/", "");
                    }
                    this.plugin.getServer().sendServerCommand(command);
                    break;
                }
                this.sendErrorMessage(ctx, "Unexpected type of data.");
                break;
            }
            case "autocomplete": {
                if (!sessions.contains(session)) {
                    ctx.closeSession(1008, "Unauthorized.");
                    return;
                }
                if (packet.data instanceof Number) {
                    Number arg = (Number)packet.data;
                    if (arg.equals(1.0)) {
                        ctx.send(new TerminalPacket<List<String>>("autocomplete", this.plugin.getServer().getCommands()));
                        return;
                    }
                    List<OPanelPlayer> players = this.plugin.getServer().getOnlinePlayers();
                    ArrayList<String> nameList = new ArrayList<String>();
                    for (OPanelPlayer player : players) {
                        nameList.add(player.getName());
                    }
                    ctx.send(new TerminalPacket("autocomplete", nameList));
                    break;
                }
                this.sendErrorMessage(ctx, "Unexpected type of data.");
                break;
            }
            default: {
                this.sendErrorMessage(ctx, "Unexpected type of packet.");
            }
        }
    }

    public void onClose(WsCloseContext ctx) {
        sessions.remove(ctx.session);
    }

    private void sendErrorMessage(WsMessageContext ctx, String err) {
        ctx.send(new TerminalPacket<String>("error", err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void broadcast(TerminalPacket<T> packet) {
        String message = new Gson().toJson(packet);
        Set<Session> set = sessions;
        synchronized (set) {
            sessions.removeIf(session -> !session.isOpen());
            for (Session session2 : sessions) {
                try {
                    session2.getRemote().sendString(message);
                }
                catch (Exception e) {
                    System.err.println("[OPanel] Failed to broadcast message to session: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllSessions() throws IOException {
        Set<Session> set = sessions;
        synchronized (set) {
            for (Session session : sessions) {
                session.close(1000, "Server is stopping.");
            }
            sessions.clear();
        }
    }
}

