/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.common.OPanelServer;
import net.opanel.deps.javalin.http.ContentType;
import net.opanel.deps.javalin.http.Context;
import net.opanel.deps.javalin.http.HttpStatus;

public abstract class BaseController {
    protected final OPanel plugin;
    protected final OPanelServer server;

    public BaseController(OPanel plugin) {
        this.plugin = plugin;
        this.server = plugin.getServer();
    }

    protected void sendResponse(Context ctx, HttpStatus status) {
        this.sendResponse(ctx, status, status.getMessage());
    }

    protected void sendResponse(Context ctx, HttpStatus status, String msg) {
        ctx.status(status);
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("code", status.getCode());
        jsonObj.put("error", msg);
        ctx.json(jsonObj);
    }

    protected void sendResponse(Context ctx, HashMap<String, Object> jsonObj) {
        HttpStatus okStatus = HttpStatus.OK;
        ctx.status(okStatus);
        jsonObj.put("code", okStatus.getCode());
        jsonObj.put("error", "");
        ctx.json(jsonObj);
    }

    protected void sendContent(Context ctx, byte[] bytes, ContentType contentType) {
        ctx.status(HttpStatus.OK);
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            ctx.result("");
            ctx.writeSeekableStream(is, contentType.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }
}

