/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.web;

import net.opanel.OPanel;
import net.opanel.controller.BaseController;
import net.opanel.controller.BeforeController;
import net.opanel.controller.ErrorController;
import net.opanel.controller.api.AuthController;
import net.opanel.controller.api.BannedIpsController;
import net.opanel.controller.api.ControlController;
import net.opanel.controller.api.DownloadController;
import net.opanel.controller.api.GamerulesController;
import net.opanel.controller.api.IconController;
import net.opanel.controller.api.InfoController;
import net.opanel.controller.api.LogsController;
import net.opanel.controller.api.MonitorController;
import net.opanel.controller.api.PlayersController;
import net.opanel.controller.api.SavesController;
import net.opanel.controller.api.SecurityController;
import net.opanel.controller.api.VersionController;
import net.opanel.controller.api.WhitelistController;
import net.opanel.deps.gson.Gson;
import net.opanel.deps.javalin.Javalin;
import net.opanel.deps.javalin.apibuilder.ApiBuilder;
import net.opanel.deps.javalin.config.SizeUnit;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.deps.javalin.jetty.JettyServer;
import net.opanel.deps.javalin.json.JavalinGson;
import net.opanel.deps.javalin.util.JavalinLogger;
import net.opanel.deps.javalin.websocket.WsConfig;
import net.opanel.endpoint.PlayersEndpoint;
import net.opanel.endpoint.TerminalEndpoint;

public class WebServer {
    public static final String ROOT_PATH = "web";
    public final int PORT;
    private final OPanel plugin;
    private Javalin app;

    public WebServer(OPanel plugin) {
        this.plugin = plugin;
        this.PORT = plugin.getConfig().webServerPort;
        JavalinLogger.enabled = false;
    }

    public void start() throws Exception {
        this.app = Javalin.create(config -> {
            config.showJavalinBanner = false;
            config.jsonMapper(new JavalinGson(new Gson()));
            config.plugins.enableCors(cors -> cors.add(it -> {
                it.allowHost("http://localhost:3001", new String[0]);
                it.allowCredentials = true;
            }));
            config.jetty.multipartConfig.cacheDirectory(OPanel.TMP_DIR_PATH.toString());
            config.jetty.multipartConfig.maxInMemoryFileSize(10, SizeUnit.MB);
            config.staticFiles.add(staticFiles -> {
                staticFiles.hostedPath = "/";
                staticFiles.directory = "/web";
            });
        });
        this.app.ws("/socket/players", ws -> new PlayersEndpoint(this.app, (WsConfig)ws, this.plugin));
        this.app.ws("/socket/terminal", ws -> new TerminalEndpoint(this.app, (WsConfig)ws, this.plugin));
        BeforeController beforeController = new BeforeController(this.plugin);
        ErrorController errorController = new ErrorController(this.plugin);
        DownloadController downloadController = new DownloadController(this.plugin);
        AuthController authController = new AuthController(this.plugin);
        BannedIpsController bannedIpsController = new BannedIpsController(this.plugin);
        ControlController controlController = new ControlController(this.plugin);
        GamerulesController gamerulesController = new GamerulesController(this.plugin);
        IconController iconController = new IconController(this.plugin);
        InfoController infoController = new InfoController(this.plugin);
        LogsController logsController = new LogsController(this.plugin);
        MonitorController monitorController = new MonitorController(this.plugin);
        PlayersController playersController = new PlayersController(this.plugin);
        SavesController savesController = new SavesController(this.plugin);
        SecurityController securityController = new SecurityController(this.plugin);
        VersionController versionController = new VersionController(this.plugin);
        WhitelistController whitelistController = new WhitelistController(this.plugin);
        this.app.before("/*", beforeController.beforeAll);
        this.app.before("/*", beforeController.handleRsc);
        this.app.before("/*", beforeController.handleFonts);
        this.app.routes(() -> ApiBuilder.path("file", () -> {
            ApiBuilder.before("/*", beforeController.authCookie);
            ApiBuilder.get("/{id}/{fileName}", downloadController.downloadFile);
        }));
        this.app.routes(() -> ApiBuilder.path("api", () -> {
            ApiBuilder.before("/*", beforeController.authCookie);
            ApiBuilder.path("auth", () -> {
                ApiBuilder.get("/", authController.getCram);
                ApiBuilder.post("/", authController.validateCram);
            });
            ApiBuilder.path("banned-ips", () -> {
                ApiBuilder.get("/", bannedIpsController.getBannedIps);
                ApiBuilder.post("add", bannedIpsController.banIp);
                ApiBuilder.post("remove", bannedIpsController.pardonIp);
            });
            ApiBuilder.path("control", () -> {
                ApiBuilder.get("properties", controlController.getServerProperties);
                ApiBuilder.post("properties", controlController.setServerProperties);
                ApiBuilder.get("code-of-conduct", controlController.getCodeOfConducts);
                ApiBuilder.post("code-of-conduct", controlController.changeCodeOfConduct);
                ApiBuilder.delete("code-of-conduct", controlController.removeCodeOfConduct);
                ApiBuilder.post("stop", controlController.stopServer);
                ApiBuilder.post("reload", controlController.reloadServer);
                ApiBuilder.post("world", controlController.switchSave);
            });
            ApiBuilder.path("gamerules", () -> {
                ApiBuilder.get("/", gamerulesController.getGamerules);
                ApiBuilder.post("/", gamerulesController.changeGamerule);
            });
            ApiBuilder.path("icon", () -> {
                ApiBuilder.get("/", iconController.getFavicon);
                ApiBuilder.post("/", iconController.uploadFavicon);
            });
            ApiBuilder.path("info", () -> {
                ApiBuilder.get("/", infoController.getServerInfo);
                ApiBuilder.post("motd", infoController.setMotd);
            });
            ApiBuilder.path("logs", () -> {
                ApiBuilder.get("/", logsController.getLogFileList);
                ApiBuilder.get("{fileName}", logsController.getLogContent);
                ApiBuilder.get("{fileName}/download", logsController.downloadLog);
                ApiBuilder.delete("/", logsController.clearLogs);
                ApiBuilder.delete("{fileName}", logsController.deleteLog);
            });
            ApiBuilder.get("monitor", monitorController.getMonitor);
            ApiBuilder.path("players", () -> {
                ApiBuilder.get("/", playersController.getPlayers);
                ApiBuilder.delete("/", playersController.deletePlayerData);
                ApiBuilder.post("op", playersController.giveOp);
                ApiBuilder.post("deop", playersController.depriveOp);
                ApiBuilder.post("kick", playersController.kickPlayer);
                ApiBuilder.post("ban", playersController.banPlayer);
                ApiBuilder.post("pardon", playersController.pardonPlayer);
                ApiBuilder.post("gamemode", playersController.setGamemode);
            });
            ApiBuilder.path("saves", () -> {
                ApiBuilder.get("/", savesController.getSaves);
                ApiBuilder.post("/", savesController.uploadSave);
                ApiBuilder.get("{saveName}", savesController.downloadSave);
                ApiBuilder.post("{saveName}", savesController.editSave);
                ApiBuilder.delete("{saveName}", savesController.deleteSave);
            });
            ApiBuilder.post("security", securityController.updateAccessKey);
            ApiBuilder.get("version", versionController.getVersionInfo);
            ApiBuilder.path("whitelist", () -> {
                ApiBuilder.get("/", whitelistController.getWhitelist);
                ApiBuilder.post("enable", whitelistController.enableWhitelist);
                ApiBuilder.post("disable", whitelistController.disableWhitelist);
                ApiBuilder.post("write", whitelistController.writeWhitelist);
                ApiBuilder.post("add", whitelistController.addWhitelistEntry);
                ApiBuilder.post("remove", whitelistController.removeWhitelistEntry);
            });
        }));
        this.app.error(HttpStatus.NOT_FOUND, errorController.notFound);
        this.app.start(this.PORT);
        this.plugin.logger.info("OPanel web server is ready on port " + this.PORT);
        this.plugin.initializeAccessKey();
        this.app.events(event -> event.serverStopping(BaseController::unregisterAllControllerInstances));
    }

    public void stop() throws Exception {
        if (this.isRunning()) {
            this.app.stop();
            this.app = null;
            this.plugin.logger.info("Web server is stopped.");
        }
    }

    public boolean isRunning() {
        if (this.app == null) {
            return false;
        }
        JettyServer jettyServer = this.app.jettyServer();
        return jettyServer != null && jettyServer.started;
    }
}

