/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.gson.io;

import io.jsonwebtoken.gson.io.GsonSupplierSerializer;
import io.jsonwebtoken.io.AbstractSerializer;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Supplier;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import net.opanel.deps.gson.Gson;
import net.opanel.deps.gson.GsonBuilder;
import net.opanel.deps.gson.ToNumberPolicy;

public class GsonSerializer<T>
extends AbstractSerializer<T> {
    static final Gson DEFAULT_GSON = new GsonBuilder().setObjectToNumberStrategy(ToNumberPolicy.LONG_OR_DOUBLE).setNumberToNumberStrategy(ToNumberPolicy.LONG_OR_DOUBLE).registerTypeHierarchyAdapter(Supplier.class, GsonSupplierSerializer.INSTANCE).disableHtmlEscaping().create();
    protected final Gson gson;

    public GsonSerializer() {
        this(DEFAULT_GSON);
    }

    public GsonSerializer(Gson gson) {
        Assert.notNull(gson, "gson cannot be null.");
        this.gson = gson;
        String json = this.gson.toJson(TestSupplier.INSTANCE);
        if (json.contains("value")) {
            String msg = "Invalid Gson instance - it has not been registered with the necessary " + Supplier.class.getName() + " type adapter.  When using the GsonBuilder, ensure this " + "type adapter is registered by calling gsonBuilder.registerTypeHierarchyAdapter(" + Supplier.class.getName() + ".class, " + GsonSupplierSerializer.class.getName() + ".INSTANCE) before calling gsonBuilder.create()";
            throw new IllegalArgumentException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSerialize(T t, OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        try {
            Object o = t;
            if (o instanceof byte[]) {
                o = Encoders.BASE64.encode((byte[])o);
            } else if (o instanceof char[]) {
                o = new String((char[])o);
            }
            this.writeValue(o, writer);
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(writer);
            throw throwable;
        }
        Objects.nullSafeClose(writer);
    }

    protected void writeValue(Object o, Writer writer) {
        this.gson.toJson(o, (Appendable)writer);
    }

    private static class TestSupplier<T>
    implements Supplier<T> {
        private static final TestSupplier<String> INSTANCE = new TestSupplier<String>("test");
        private final T value;

        private TestSupplier(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }
    }
}

