/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.controller.api;

import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.config.OPanelConfiguration;
import net.opanel.controller.BaseController;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.utils.Utils;
import net.opanel.web.JwtManager;

public class SecurityController
extends BaseController {
    public Handler updateAccessKey = ctx -> {
        RequestBodyType reqBody = ctx.bodyAsClass(RequestBodyType.class);
        if (reqBody == null || reqBody.currentKey == null || reqBody.newKey == null) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Invalid request body.");
            return;
        }
        String currentKey = reqBody.currentKey;
        String newKey = reqBody.newKey;
        String realKey = this.plugin.getConfig().accessKey;
        if (!Utils.md5(currentKey).equals(realKey)) {
            this.sendResponse(ctx, HttpStatus.FORBIDDEN, "Access key mismatch.");
            return;
        }
        OPanelConfiguration config = this.plugin.getConfig();
        config.accessKey = Utils.md5(newKey);
        this.plugin.setConfig(config);
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("token", JwtManager.generateToken(config.accessKey, config.salt));
        this.sendResponse(ctx, obj);
    };

    public SecurityController(OPanel plugin) {
        super(plugin);
    }

    private static class RequestBodyType {
        String currentKey;
        String newKey;

        private RequestBodyType() {
        }
    }
}

