/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.fabric_1_21_9;

import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1934;
import net.minecraft.server.MinecraftServer;
import net.opanel.common.OPanelGameMode;
import net.opanel.event.EventManager;
import net.opanel.event.EventType;
import net.opanel.event.OPanelPlayerGameModeChangeEvent;
import net.opanel.event.OPanelPlayerJoinEvent;
import net.opanel.event.OPanelPlayerLeaveEvent;
import net.opanel.fabric_1_21_9.FabricPlayer;
import net.opanel.fabric_helper.event.PlayerGameModeChangeEvent;

public class FabricListener {
    public FabricListener() {
        ServerLifecycleEvents.SERVER_STARTED.register(this::registerListeners);
    }

    private void registerListeners(MinecraftServer server) {
        ServerPlayerEvents.JOIN.register(player -> EventManager.get().emit(EventType.PLAYER_JOIN, new OPanelPlayerJoinEvent(new FabricPlayer(player, server))));
        ServerPlayerEvents.LEAVE.register(player -> EventManager.get().emit(EventType.PLAYER_LEAVE, new OPanelPlayerLeaveEvent(new FabricPlayer(player, server))));
        PlayerGameModeChangeEvent.EVENT.register((player, gamemode) -> EventManager.get().emit(EventType.PLAYER_GAMEMODE_CHANGE, new OPanelPlayerGameModeChangeEvent(new FabricPlayer(player, server), switch (gamemode) {
            case class_1934.field_9216 -> OPanelGameMode.ADVENTURE;
            case class_1934.field_9215 -> OPanelGameMode.SURVIVAL;
            case class_1934.field_9220 -> OPanelGameMode.CREATIVE;
            case class_1934.field_9219 -> OPanelGameMode.SPECTATOR;
            default -> null;
        })));
    }
}

