/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.controller.api;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.controller.BaseController;
import net.opanel.controller.api.DownloadController;
import net.opanel.deps.javalin.http.ContentType;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.logger.Loggable;

public class LogsController
extends BaseController {
    private final DownloadController downloadController = this.getControllerInstance(DownloadController.class);
    public Handler getLogFileList = ctx -> {
        Loggable logger = this.plugin.logger;
        try {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("logs", logger.getLogFileList());
            this.sendResponse(ctx, obj);
        }
        catch (IOException e) {
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler getLogContent = ctx -> {
        Loggable logger = this.plugin.logger;
        String fileName = ctx.pathParam("fileName");
        try {
            this.sendContent(ctx, logger.getLogContent(fileName).getBytes(StandardCharsets.UTF_8), ContentType.TEXT_PLAIN);
        }
        catch (NoSuchFileException e) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND, "Cannot find the specified log file.");
        }
        catch (IllegalArgumentException e) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Illegal file extension.");
        }
        catch (IOException e) {
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler downloadLog = ctx -> {
        Loggable logger = this.plugin.logger;
        String fileName = ctx.pathParam("fileName");
        String downloadedFileName = fileName.endsWith(".log.gz") ? fileName.replace(".log.gz", ".log") : fileName;
        String downloadId = this.downloadController.registerContent(logger.getLogContent(fileName));
        ctx.redirect("/file/" + downloadId + "/" + downloadedFileName);
    };
    public Handler clearLogs = ctx -> {
        Loggable logger = this.plugin.logger;
        try {
            for (String fileName : logger.getLogFileList()) {
                if (!fileName.endsWith(".log.gz")) continue;
                logger.deleteLog(fileName);
            }
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (NoSuchFileException e) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND, "Cannot find the specified log file.");
        }
        catch (IOException e) {
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler deleteLog = ctx -> {
        Loggable logger = this.plugin.logger;
        String fileName = ctx.pathParam("fileName");
        if (fileName.endsWith(".log")) {
            this.sendResponse(ctx, HttpStatus.FORBIDDEN, "You cannot delete latest.log or debug.log.");
            return;
        }
        try {
            logger.deleteLog(fileName);
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (NoSuchFileException e) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND, "Cannot find the specified log file.");
        }
        catch (IOException e) {
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };

    public LogsController(OPanel plugin) {
        super(plugin);
    }
}

