/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_21_9;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.opanel.common.OPanelGameMode;
import net.opanel.event.EventManager;
import net.opanel.event.EventType;
import net.opanel.event.OPanelPlayerGameModeChangeEvent;
import net.opanel.event.OPanelPlayerJoinEvent;
import net.opanel.event.OPanelPlayerLeaveEvent;
import net.opanel.forge_1_21_9.ForgePlayer;

public class ForgeListener {
    private MinecraftServer server;

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        this.server = event.getServer();
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.server == null) {
            return;
        }
        EventManager.get().emit(EventType.PLAYER_JOIN, new OPanelPlayerJoinEvent(new ForgePlayer((ServerPlayer)event.getEntity(), this.server)));
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (this.server == null) {
            return;
        }
        EventManager.get().emit(EventType.PLAYER_LEAVE, new OPanelPlayerLeaveEvent(new ForgePlayer((ServerPlayer)event.getEntity(), this.server)));
    }

    @SubscribeEvent
    public void onPlayerGameModeChange(PlayerEvent.PlayerChangeGameModeEvent event) {
        if (this.server == null) {
            return;
        }
        GameType gamemode = event.getNewGameMode();
        EventManager.get().emit(EventType.PLAYER_GAMEMODE_CHANGE, new OPanelPlayerGameModeChangeEvent(new ForgePlayer((ServerPlayer)event.getEntity(), this.server), switch (gamemode) {
            case GameType.ADVENTURE -> OPanelGameMode.ADVENTURE;
            case GameType.SURVIVAL -> OPanelGameMode.SURVIVAL;
            case GameType.CREATIVE -> OPanelGameMode.CREATIVE;
            case GameType.SPECTATOR -> OPanelGameMode.SPECTATOR;
            default -> null;
        }));
    }
}

