/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.deps.oshi;

import com.sun.jna.Platform;
import java.util.function.Supplier;
import net.opanel.deps.oshi.PlatformEnum;
import net.opanel.deps.oshi.hardware.HardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.linux.LinuxHardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.mac.MacHardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.unix.aix.AixHardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.unix.freebsd.FreeBsdHardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.unix.openbsd.OpenBsdHardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.unix.solaris.SolarisHardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsHardwareAbstractionLayer;
import net.opanel.deps.oshi.software.os.OperatingSystem;
import net.opanel.deps.oshi.software.os.linux.LinuxOperatingSystem;
import net.opanel.deps.oshi.software.os.mac.MacOperatingSystem;
import net.opanel.deps.oshi.software.os.unix.aix.AixOperatingSystem;
import net.opanel.deps.oshi.software.os.unix.freebsd.FreeBsdOperatingSystem;
import net.opanel.deps.oshi.software.os.unix.openbsd.OpenBsdOperatingSystem;
import net.opanel.deps.oshi.software.os.unix.solaris.SolarisOperatingSystem;
import net.opanel.deps.oshi.software.os.windows.WindowsOperatingSystem;
import net.opanel.deps.oshi.util.Memoizer;

public class SystemInfo {
    private static final PlatformEnum CURRENT_PLATFORM = PlatformEnum.getValue(Platform.getOSType());
    private static final String NOT_SUPPORTED = "Operating system not supported: ";
    private final Supplier<OperatingSystem> os = Memoizer.memoize(SystemInfo::createOperatingSystem);
    private final Supplier<HardwareAbstractionLayer> hardware = Memoizer.memoize(SystemInfo::createHardware);

    public static PlatformEnum getCurrentPlatform() {
        return CURRENT_PLATFORM;
    }

    public OperatingSystem getOperatingSystem() {
        return this.os.get();
    }

    private static OperatingSystem createOperatingSystem() {
        switch (CURRENT_PLATFORM) {
            case WINDOWS: {
                return new WindowsOperatingSystem();
            }
            case LINUX: 
            case ANDROID: {
                return new LinuxOperatingSystem();
            }
            case MACOS: {
                return new MacOperatingSystem();
            }
            case SOLARIS: {
                return new SolarisOperatingSystem();
            }
            case FREEBSD: {
                return new FreeBsdOperatingSystem();
            }
            case AIX: {
                return new AixOperatingSystem();
            }
            case OPENBSD: {
                return new OpenBsdOperatingSystem();
            }
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED + CURRENT_PLATFORM.getName());
    }

    public HardwareAbstractionLayer getHardware() {
        return this.hardware.get();
    }

    private static HardwareAbstractionLayer createHardware() {
        switch (CURRENT_PLATFORM) {
            case WINDOWS: {
                return new WindowsHardwareAbstractionLayer();
            }
            case LINUX: 
            case ANDROID: {
                return new LinuxHardwareAbstractionLayer();
            }
            case MACOS: {
                return new MacHardwareAbstractionLayer();
            }
            case SOLARIS: {
                return new SolarisHardwareAbstractionLayer();
            }
            case FREEBSD: {
                return new FreeBsdHardwareAbstractionLayer();
            }
            case AIX: {
                return new AixHardwareAbstractionLayer();
            }
            case OPENBSD: {
                return new OpenBsdHardwareAbstractionLayer();
            }
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED + CURRENT_PLATFORM.getName());
    }
}

