/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.controller.api;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.opanel.OPanel;
import net.opanel.controller.BaseController;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.utils.Utils;
import net.opanel.web.JwtManager;

public class AuthController
extends BaseController {
    private final ConcurrentHashMap<String, String> cramMap = new ConcurrentHashMap();
    private static final int maxTries = 5;
    private static final long bannedPeriod = 600000L;
    private final ConcurrentHashMap<String, Integer> failedRecords = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> temporaryBannedRecords = new ConcurrentHashMap();
    public Handler getCram = ctx -> {
        String id = ctx.queryParam("id");
        if (id == null) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Id is missing.");
            return;
        }
        String remoteHost = ctx.host();
        if (remoteHost == null) {
            this.sendResponse(ctx, HttpStatus.FORBIDDEN, "Host is missing in request header.");
            return;
        }
        if (System.currentTimeMillis() < this.temporaryBannedRecords.getOrDefault(remoteHost, 0L)) {
            this.sendResponse(ctx, HttpStatus.FORBIDDEN, "The Ip is banned temporarily.");
            return;
        }
        if (this.failedRecords.getOrDefault(remoteHost, 0) >= 5) {
            this.temporaryBannedRecords.put(remoteHost, System.currentTimeMillis() + 600000L);
            this.failedRecords.put(remoteHost, 0);
            this.sendResponse(ctx, HttpStatus.FORBIDDEN, "The Ip is banned temporarily.");
            return;
        }
        if (this.temporaryBannedRecords.containsKey(remoteHost) && System.currentTimeMillis() >= this.temporaryBannedRecords.get(remoteHost)) {
            this.temporaryBannedRecords.remove(remoteHost);
        }
        String cramRandomHex = Utils.generateRandomHex(16);
        while (this.cramMap.containsValue(cramRandomHex)) {
            cramRandomHex = Utils.generateRandomHex(16);
        }
        this.cramMap.put(id, cramRandomHex);
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("cram", cramRandomHex);
        this.sendResponse(ctx, res);
    };
    public Handler validateCram = ctx -> {
        RequestBodyType reqBody = ctx.bodyAsClass(RequestBodyType.class);
        if (reqBody.id == null || reqBody.result == null) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Id or result is missing.");
            return;
        }
        String remoteHost = ctx.host();
        String challengeResult = reqBody.result;
        String storedRealKey = this.plugin.getConfig().accessKey;
        String realResult = Utils.md5(storedRealKey + this.cramMap.get(reqBody.id));
        this.cramMap.remove(reqBody.id);
        if (challengeResult.equals(realResult)) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("token", JwtManager.generateToken(storedRealKey, this.plugin.getConfig().salt));
            this.failedRecords.remove(remoteHost);
            this.sendResponse(ctx, obj);
        } else {
            int current = this.failedRecords.getOrDefault(remoteHost, 0);
            this.failedRecords.put(remoteHost, current + 1);
            if (current + 1 >= 5) {
                this.temporaryBannedRecords.put(remoteHost, System.currentTimeMillis() + 600000L);
                this.failedRecords.put(remoteHost, 0);
            }
            this.plugin.logger.warn("A failed login request from " + remoteHost + " (Failed for " + (current + 1) + " times)");
            this.sendResponse(ctx, HttpStatus.UNAUTHORIZED);
        }
    };

    public AuthController(OPanel plugin) {
        super(plugin);
    }

    private static class RequestBodyType {
        String id;
        String result;

        private RequestBodyType() {
        }
    }
}

