/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.fabric_helper;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.opanel.common.OPanelPlayer;

public abstract class BaseFabricOfflinePlayer
implements OPanelPlayer {
    protected static final long NBT_TRACKER_SIZE = 0x200000L;
    protected final class_3324 playerManager;
    protected final Path playerDataPath;
    protected final UUID uuid;

    public BaseFabricOfflinePlayer(MinecraftServer server, UUID uuid) {
        this.playerManager = server.method_3760();
        this.playerDataPath = server.method_27050(class_5218.field_24182).resolve(String.valueOf(uuid) + ".dat");
        this.uuid = uuid;
        if (!Files.exists(this.playerDataPath, new LinkOption[0])) {
            throw new NullPointerException("Player data file for UUID " + String.valueOf(uuid) + " unavailable.");
        }
        class_3222 serverPlayer = this.playerManager.method_14602(uuid);
        if (serverPlayer != null && !serverPlayer.method_14239()) {
            throw new IllegalStateException("The provided player is online, please use FabricPlayer class instead.");
        }
    }

    @Override
    public String getUUID() {
        return this.uuid.toString();
    }

    @Override
    public boolean isOnline() {
        return false;
    }

    @Override
    public void kick(String reason) {
        throw new IllegalStateException("The player is offline.");
    }

    @Override
    public int getPing() {
        throw new IllegalStateException("The player is offline.");
    }
}

