/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.fabric_1_21_9;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11560;
import net.minecraft.class_11755;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_3335;
import net.minecraft.class_3336;
import net.minecraft.server.MinecraftServer;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;
import net.opanel.fabric_helper.BaseFabricOfflinePlayer;

public class FabricOfflinePlayer
extends BaseFabricOfflinePlayer
implements OPanelPlayer {
    private final GameProfile profile;

    public FabricOfflinePlayer(MinecraftServer server, UUID uuid) {
        super(server, uuid);
        class_11755 profileCache = server.method_73550().comp_4624();
        Optional profileOpt = profileCache.method_73290(uuid);
        if (profileOpt.isEmpty()) {
            throw new NullPointerException("Cannot get the game profile of the provided player.");
        }
        this.profile = (GameProfile)profileOpt.get();
    }

    @Override
    public String getName() {
        return this.profile.name();
    }

    @Override
    public boolean isOp() {
        return this.playerManager.method_14569(new class_11560(this.profile));
    }

    @Override
    public boolean isBanned() {
        return this.playerManager.method_14563().method_14650(new class_11560(this.profile));
    }

    @Override
    public OPanelGameMode getGameMode() {
        try {
            class_2487 nbt = class_2507.method_30613((Path)this.playerDataPath, (class_2505)class_2505.method_53899((long)0x200000L));
            int gamemodeId = nbt.method_68083("playerGameType", 0);
            return OPanelGameMode.fromId(gamemodeId);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        try {
            class_2487 nbt = class_2507.method_30613((Path)this.playerDataPath, (class_2505)class_2505.method_53899((long)0x200000L));
            nbt.method_10569("playerGameType", gamemode.getId());
            class_2507.method_30614((class_2487)nbt, (Path)this.playerDataPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.playerManager.method_14582(new class_11560(this.profile));
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.playerManager.method_14604(new class_11560(this.profile));
    }

    @Override
    public void ban(String reason) {
        if (this.isBanned()) {
            return;
        }
        class_3335 bannedList = this.playerManager.method_14563();
        class_3336 entry = new class_3336(new class_11560(this.profile), new Date(), null, null, reason);
        bannedList.method_74006(entry);
    }

    @Override
    public String getBanReason() {
        if (!this.isBanned()) {
            return null;
        }
        class_3336 banEntry = (class_3336)this.playerManager.method_14563().method_14640((Object)new class_11560(this.profile));
        if (banEntry == null) {
            return null;
        }
        return banEntry.method_14503();
    }

    @Override
    public void pardon() {
        if (!this.isBanned()) {
            return;
        }
        this.playerManager.method_14563().method_74007(new class_11560(this.profile));
    }
}

