/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_21_3;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.opanel.common.OPanelDifficulty;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.forge_helper.BaseForgeSave;
import net.opanel.forge_helper.ForgeUtils;

public class ForgeSave
extends BaseForgeSave
implements OPanelSave {
    private CompoundTag nbt;

    public ForgeSave(MinecraftServer server, Path path) {
        super(server, path);
        try {
            this.nbt = NbtIo.readCompressed((Path)this.savePath.resolve("level.dat"), (NbtAccounter)NbtAccounter.create((long)0x200000L)).getCompound("Data");
            if (this.nbt.isEmpty()) {
                throw new IOException("Cannot find a valid level.dat");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void saveNbt() throws IOException {
        CompoundTag dataNbt = new CompoundTag();
        dataNbt.put("Data", (Tag)this.nbt);
        NbtIo.writeCompressed((CompoundTag)dataNbt, (Path)this.savePath.resolve("level.dat"));
    }

    @Override
    public String getDisplayName() {
        return this.nbt.getString("LevelName").replaceAll("\u00c2", "");
    }

    @Override
    public void setDisplayName(String displayName) throws IOException {
        this.nbt.putString("LevelName", displayName);
        this.saveNbt();
    }

    @Override
    public OPanelGameMode getDefaultGameMode() {
        int gamemode = this.nbt.getInt("GameType");
        return OPanelGameMode.fromId(gamemode);
    }

    @Override
    public void setDefaultGameMode(OPanelGameMode gamemode) throws IOException {
        this.nbt.putInt("GameType", gamemode.getId());
        this.saveNbt();
    }

    @Override
    public OPanelDifficulty getDifficulty() throws IOException {
        if (this.isCurrent()) {
            return OPanelDifficulty.fromId(this.getCurrentWorld().getDifficulty().getId());
        }
        byte difficulty = this.nbt.getByte("Difficulty");
        return OPanelDifficulty.fromId(difficulty);
    }

    @Override
    public void setDifficulty(OPanelDifficulty difficulty) throws IOException {
        if (this.isCurrent()) {
            this.server.setDifficulty(Difficulty.byName((String)difficulty.getName()), true);
        }
        this.nbt.putByte("Difficulty", (byte)difficulty.getId());
        this.saveNbt();
    }

    @Override
    public boolean isDifficultyLocked() throws IOException {
        if (this.isCurrent()) {
            return this.getCurrentWorld().getLevelData().isDifficultyLocked();
        }
        return this.nbt.getByte("DifficultyLocked") == 1;
    }

    @Override
    public void setDifficultyLocked(boolean locked) throws IOException {
        if (this.isCurrent()) {
            this.server.setDifficultyLocked(locked);
        }
        this.nbt.putByte("DifficultyLocked", (byte)(locked ? 1 : 0));
        this.saveNbt();
    }

    @Override
    public boolean isHardcore() throws IOException {
        if (this.isCurrent()) {
            return this.server.isHardcore();
        }
        return this.nbt.getByte("hardcore") == 1;
    }

    @Override
    public void setHardcoreEnabled(boolean enabled) throws IOException {
        if (this.isCurrent()) {
            PrimaryLevelData worldData = (PrimaryLevelData)this.getCurrentWorld().getLevelData();
            LevelSettings currentSettings = worldData.getLevelSettings();
            LevelSettings newSettings = new LevelSettings(currentSettings.levelName(), currentSettings.gameType(), enabled, currentSettings.difficulty(), currentSettings.allowCommands(), currentSettings.gameRules(), currentSettings.getDataConfiguration());
            try {
                Field settingsField = PrimaryLevelData.class.getDeclaredField("settings");
                settingsField.setAccessible(true);
                settingsField.set(worldData, newSettings);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("hardcore=.+", "hardcore=" + enabled));
            ForgeUtils.forceUpdateProperties((DedicatedServer)this.server, false);
        }
        this.nbt.putByte("hardcore", (byte)(enabled ? 1 : 0));
        this.saveNbt();
    }

    @Override
    public HashMap<String, Boolean> getDatapacks() {
        HashMap<String, Boolean> datapacks = new HashMap<String, Boolean>();
        CompoundTag datapacksNbt = this.nbt.getCompound("DataPacks");
        datapacksNbt.getList("Enabled", 8).forEach(tag -> datapacks.put(tag.getAsString(), true));
        datapacksNbt.getList("Disabled", 8).forEach(tag -> datapacks.put(tag.getAsString(), false));
        return datapacks;
    }

    @Override
    public void toggleDatapack(String id, boolean enabled) throws IOException {
        Boolean currentEnabled = this.getDatapacks().get(id);
        if (currentEnabled == null || currentEnabled == enabled) {
            return;
        }
        if (id.equals("vanilla")) {
            return;
        }
        if (this.isCurrent()) {
            this.server.getCommands().performPrefixedCommand(this.server.createCommandSourceStack(), "datapack " + (enabled ? "enable" : "disable") + " \"" + id + "\"");
        }
        CompoundTag datapacksNbt = this.nbt.getCompound("DataPacks");
        if (enabled) {
            datapacksNbt.getList("Disabled", 8).remove((Object)StringTag.valueOf((String)id));
            datapacksNbt.getList("Enabled", 8).add((Object)StringTag.valueOf((String)id));
        } else {
            datapacksNbt.getList("Enabled", 8).remove((Object)StringTag.valueOf((String)id));
            datapacksNbt.getList("Disabled", 8).add((Object)StringTag.valueOf((String)id));
        }
        this.saveNbt();
    }
}

