/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.controller.api;

import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.controller.BaseController;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.oshi.SystemInfo;
import net.opanel.deps.oshi.hardware.GlobalMemory;
import net.opanel.time.TPS;

public class MonitorController
extends BaseController {
    public Handler getMonitor = ctx -> {
        SystemInfo si = new SystemInfo();
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("cpu", this.getCpuRate(si));
        obj.put("memory", this.getMemoryRate(si));
        obj.put("tps", TPS.getRecentTPS());
        this.sendResponse(ctx, obj);
    };

    public MonitorController(OPanel plugin) {
        super(plugin);
    }

    private double getCpuRate(SystemInfo si) {
        double loadPercentage = si.getHardware().getProcessor().getSystemCpuLoad(500L) * 100.0;
        return Math.round(loadPercentage);
    }

    private double getMemoryRate(SystemInfo si) {
        GlobalMemory gm = si.getHardware().getMemory();
        long total = gm.getTotal();
        long available = gm.getAvailable();
        long used = total - available;
        double rate = (double)used / (double)total * 100.0;
        return Math.round(rate);
    }
}

