/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.bukkit_helper;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.opanel.bukkit_helper.TaskRunner;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelServer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.help.HelpTopic;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BaseBukkitServer
implements OPanelServer {
    protected final JavaPlugin plugin;
    protected final TaskRunner runner;
    protected final Server server;

    public BaseBukkitServer(JavaPlugin plugin, Server server) {
        this.plugin = plugin;
        this.runner = (TaskRunner)plugin;
        this.server = server;
    }

    @Override
    public String getMotd() {
        return this.server.getMotd();
    }

    @Override
    public String getVersion() {
        return this.server.getBukkitVersion().split("-")[0];
    }

    @Override
    public int getPort() {
        return this.server.getPort();
    }

    @Override
    public void saveAll() {
        this.runner.runTask(() -> {
            for (World world : this.server.getWorlds()) {
                world.save();
            }
            this.server.savePlayers();
        });
    }

    @Override
    public int getMaxPlayerCount() {
        return this.server.getMaxPlayers();
    }

    @Override
    public OPanelPlayer getPlayer(String uuid) {
        for (OPanelPlayer player : this.getPlayers()) {
            if (!player.getUUID().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    @Override
    public void removePlayerData(String uuid) throws IOException {
        Path playerDataFolder = ((World)this.server.getWorlds().get(0)).getWorldFolder().toPath().resolve("playerdata");
        Files.deleteIfExists(playerDataFolder.resolve(uuid + ".dat"));
        Files.deleteIfExists(playerDataFolder.resolve(uuid + ".dat_old"));
    }

    @Override
    public List<String> getBannedIps() {
        return new ArrayList<String>(this.server.getIPBans());
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.server.hasWhitelist();
    }

    @Override
    public void setWhitelistEnabled(boolean enabled) {
        this.runner.runTask(() -> this.server.setWhitelist(enabled));
    }

    @Override
    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        for (HelpTopic topic : this.server.getHelpMap().getHelpTopics()) {
            commands.add(topic.getName().toLowerCase().replaceFirst("/", ""));
        }
        return commands;
    }

    @Override
    public void reload() {
        this.runner.runTask(() -> ((Server)this.server).reload());
    }

    @Override
    public void stop() {
        this.server.shutdown();
    }

    @Override
    public long getIngameTime() {
        return ((World)this.server.getWorlds().get(0)).getTime();
    }
}

