/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.fabric_helper;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.utils.Utils;

public abstract class BaseFabricSave
implements OPanelSave {
    protected final MinecraftServer server;
    protected final Path savePath;

    public BaseFabricSave(MinecraftServer server, Path path) {
        this.server = server;
        this.savePath = path;
    }

    protected abstract void saveNbt() throws IOException;

    protected class_3218 getCurrentWorld() {
        return this.server.method_30002();
    }

    @Override
    public String getName() {
        return this.savePath.getFileName().toString();
    }

    @Override
    public Path getPath() {
        return this.savePath.toAbsolutePath();
    }

    @Override
    public long getSize() throws IOException {
        return Utils.getDirectorySize(this.savePath);
    }

    @Override
    public boolean isRunning() {
        return this.server.method_27050(class_5218.field_24184).getParent().getFileName().toString().equals(this.getName());
    }

    @Override
    public boolean isCurrent() throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(OPanelServer.serverPropertiesPath.toFile()));
        return properties.getProperty("level-name").replaceAll("\u00c2", "").equals(this.getName());
    }

    @Override
    public void setToCurrent() throws IOException {
        if (this.isCurrent()) {
            return;
        }
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("level-name=.+", "level-name=" + this.getName()));
    }

    @Override
    public void delete() throws IOException {
        Utils.deleteDirectoryRecursively(this.savePath);
    }
}

