/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_20_1;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;
import net.opanel.forge_helper.BaseForgeOfflinePlayer;

public class ForgeOfflinePlayer
extends BaseForgeOfflinePlayer
implements OPanelPlayer {
    private final GameProfile profile;

    public ForgeOfflinePlayer(MinecraftServer server, UUID uuid) {
        super(server, uuid);
        GameProfileCache profileCache = server.m_129927_();
        if (profileCache == null) {
            throw new NullPointerException("Cannot get player profile cache.");
        }
        Optional profileOpt = profileCache.m_11002_(uuid);
        if (profileOpt.isEmpty()) {
            throw new NullPointerException("Cannot get the game profile of the provided player.");
        }
        this.profile = (GameProfile)profileOpt.get();
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public boolean isOp() {
        return this.playerManager.m_11303_(this.profile);
    }

    @Override
    public boolean isBanned() {
        return this.playerManager.m_11295_().m_11406_(this.profile);
    }

    @Override
    public OPanelGameMode getGameMode() {
        try {
            CompoundTag nbt = NbtIo.m_128937_((File)this.playerDataPath.toFile());
            int gamemodeId = nbt.m_128451_("playerGameType");
            return OPanelGameMode.fromId(gamemodeId);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        try {
            CompoundTag nbt = NbtIo.m_128937_((File)this.playerDataPath.toFile());
            nbt.m_128405_("playerGameType", gamemode.getId());
            NbtIo.m_128944_((CompoundTag)nbt, (File)this.playerDataPath.toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.playerManager.m_5749_(this.profile);
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.playerManager.m_5750_(this.profile);
    }

    @Override
    public void ban(String reason) {
        if (this.isBanned()) {
            return;
        }
        UserBanList bannedList = this.playerManager.m_11295_();
        UserBanListEntry entry = new UserBanListEntry(this.profile, new Date(), null, null, reason);
        bannedList.m_11381_((StoredUserEntry)entry);
    }

    @Override
    public String getBanReason() {
        if (!this.isBanned()) {
            return null;
        }
        UserBanListEntry banEntry = (UserBanListEntry)this.playerManager.m_11295_().m_11388_((Object)this.profile);
        if (banEntry == null) {
            return null;
        }
        return banEntry.m_10962_();
    }

    @Override
    public void pardon() {
        if (!this.isBanned()) {
            return;
        }
        this.playerManager.m_11295_().m_11393_((Object)this.profile);
    }
}

