/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.bukkit_helper;

import net.opanel.bukkit_helper.TaskRunner;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BaseBukkitPlayer
implements OPanelPlayer {
    protected final JavaPlugin plugin;
    protected final TaskRunner runner;
    protected final Player player;

    public BaseBukkitPlayer(JavaPlugin plugin, Player player) {
        this.plugin = plugin;
        this.runner = (TaskRunner)plugin;
        this.player = player;
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public String getUUID() {
        return this.player.getUniqueId().toString();
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public boolean isOp() {
        return this.player.isOp();
    }

    @Override
    public boolean isBanned() {
        return false;
    }

    @Override
    public OPanelGameMode getGameMode() {
        GameMode gamemode = this.player.getGameMode();
        switch (gamemode) {
            case ADVENTURE: {
                return OPanelGameMode.ADVENTURE;
            }
            case SURVIVAL: {
                return OPanelGameMode.SURVIVAL;
            }
            case CREATIVE: {
                return OPanelGameMode.CREATIVE;
            }
            case SPECTATOR: {
                return OPanelGameMode.SPECTATOR;
            }
        }
        return null;
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        this.runner.runTask(() -> {
            switch (gamemode) {
                case ADVENTURE: {
                    this.player.setGameMode(GameMode.ADVENTURE);
                    break;
                }
                case SURVIVAL: {
                    this.player.setGameMode(GameMode.SURVIVAL);
                    break;
                }
                case CREATIVE: {
                    this.player.setGameMode(GameMode.CREATIVE);
                    break;
                }
                case SPECTATOR: {
                    this.player.setGameMode(GameMode.SPECTATOR);
                }
            }
        });
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.runner.runTask(() -> this.player.setOp(true));
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.runner.runTask(() -> this.player.setOp(false));
    }

    @Override
    public String getBanReason() {
        return null;
    }

    @Override
    public void pardon() {
    }
}

