/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.deps.oshi.hardware.platform.unix.solaris;

import java.util.List;
import net.opanel.deps.oshi.annotation.concurrent.ThreadSafe;
import net.opanel.deps.oshi.hardware.CentralProcessor;
import net.opanel.deps.oshi.hardware.ComputerSystem;
import net.opanel.deps.oshi.hardware.Display;
import net.opanel.deps.oshi.hardware.GlobalMemory;
import net.opanel.deps.oshi.hardware.GraphicsCard;
import net.opanel.deps.oshi.hardware.HWDiskStore;
import net.opanel.deps.oshi.hardware.NetworkIF;
import net.opanel.deps.oshi.hardware.PowerSource;
import net.opanel.deps.oshi.hardware.Sensors;
import net.opanel.deps.oshi.hardware.SoundCard;
import net.opanel.deps.oshi.hardware.UsbDevice;
import net.opanel.deps.oshi.hardware.common.AbstractHardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.unix.UnixDisplay;
import net.opanel.deps.oshi.hardware.platform.unix.solaris.SolarisCentralProcessor;
import net.opanel.deps.oshi.hardware.platform.unix.solaris.SolarisComputerSystem;
import net.opanel.deps.oshi.hardware.platform.unix.solaris.SolarisGlobalMemory;
import net.opanel.deps.oshi.hardware.platform.unix.solaris.SolarisGraphicsCard;
import net.opanel.deps.oshi.hardware.platform.unix.solaris.SolarisHWDiskStore;
import net.opanel.deps.oshi.hardware.platform.unix.solaris.SolarisNetworkIF;
import net.opanel.deps.oshi.hardware.platform.unix.solaris.SolarisPowerSource;
import net.opanel.deps.oshi.hardware.platform.unix.solaris.SolarisSensors;
import net.opanel.deps.oshi.hardware.platform.unix.solaris.SolarisSoundCard;
import net.opanel.deps.oshi.hardware.platform.unix.solaris.SolarisUsbDevice;

@ThreadSafe
public final class SolarisHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    @Override
    public ComputerSystem createComputerSystem() {
        return new SolarisComputerSystem();
    }

    @Override
    public GlobalMemory createMemory() {
        return new SolarisGlobalMemory();
    }

    @Override
    public CentralProcessor createProcessor() {
        return new SolarisCentralProcessor();
    }

    @Override
    public Sensors createSensors() {
        return new SolarisSensors();
    }

    @Override
    public List<PowerSource> getPowerSources() {
        return SolarisPowerSource.getPowerSources();
    }

    @Override
    public List<HWDiskStore> getDiskStores() {
        return SolarisHWDiskStore.getDisks();
    }

    @Override
    public List<Display> getDisplays() {
        return UnixDisplay.getDisplays();
    }

    @Override
    public List<NetworkIF> getNetworkIFs(boolean includeLocalInterfaces) {
        return SolarisNetworkIF.getNetworks(includeLocalInterfaces);
    }

    @Override
    public List<UsbDevice> getUsbDevices(boolean tree) {
        return SolarisUsbDevice.getUsbDevices(tree);
    }

    @Override
    public List<SoundCard> getSoundCards() {
        return SolarisSoundCard.getSoundCards();
    }

    @Override
    public List<GraphicsCard> getGraphicsCards() {
        return SolarisGraphicsCard.getGraphicsCards();
    }
}

