/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.controller.api;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import net.opanel.OPanel;
import net.opanel.common.OPanelWhitelist;
import net.opanel.controller.BaseController;
import net.opanel.deps.gson.reflect.TypeToken;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.javalin.http.HttpStatus;

public class WhitelistController
extends BaseController {
    private static final Type whitelistType = new TypeToken<List<OPanelWhitelist.OPanelWhitelistEntry>>(){}.getType();
    public Handler getWhitelist = ctx -> {
        try {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("whitelist", this.server.getWhitelist().getEntries());
            this.sendResponse(ctx, obj);
        }
        catch (IOException e) {
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler enableWhitelist = ctx -> {
        this.server.setWhitelistEnabled(true);
        this.sendResponse(ctx, HttpStatus.OK);
    };
    public Handler disableWhitelist = ctx -> {
        this.server.setWhitelistEnabled(false);
        this.sendResponse(ctx, HttpStatus.OK);
    };
    public Handler writeWhitelist = ctx -> {
        List entries = (List)ctx.bodyAsClass(whitelistType);
        if (entries == null) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Invalid whitelist payload.");
            return;
        }
        try {
            this.server.getWhitelist().write(entries);
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (IOException e) {
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler addWhitelistEntry = ctx -> {
        String name = ctx.queryParam("name");
        String uuid = ctx.queryParam("uuid");
        if (name == null || uuid == null) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Missing name or uuid.");
            return;
        }
        try {
            this.server.getWhitelist().add(new OPanelWhitelist.OPanelWhitelistEntry(name, uuid));
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (IOException e) {
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler removeWhitelistEntry = ctx -> {
        String name = ctx.queryParam("name");
        String uuid = ctx.queryParam("uuid");
        if (name == null || uuid == null) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Missing name or uuid.");
            return;
        }
        try {
            this.server.getWhitelist().remove(new OPanelWhitelist.OPanelWhitelistEntry(name, uuid));
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (IOException e) {
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };

    public WhitelistController(OPanel plugin) {
        super(plugin);
    }
}

