/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.io.Codec;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.impl.lang.Converters;
import io.jsonwebtoken.impl.security.ECCurve;
import java.math.BigInteger;

final class FieldElementConverter
implements Converter<BigInteger, byte[]> {
    static final FieldElementConverter INSTANCE = new FieldElementConverter();
    static final Converter<BigInteger, Object> B64URL_CONVERTER = Converters.forEncoded(BigInteger.class, Converters.compound(INSTANCE, Codec.BASE64URL));
    private static final int P256_BYTE_LEN = FieldElementConverter.bytelen(ECCurve.P256);
    private static final int P384_BYTE_LEN = FieldElementConverter.bytelen(ECCurve.P384);
    private static final int P521_BYTE_LEN = FieldElementConverter.bytelen(ECCurve.P521);

    FieldElementConverter() {
    }

    private static int bytelen(ECCurve curve) {
        return Bytes.length(curve.toParameterSpec().getCurve().getField().getFieldSize());
    }

    @Override
    public byte[] applyTo(BigInteger bigInteger) {
        byte[] bytes = Converters.BIGINT_UBYTES.applyTo(bigInteger);
        int len = bytes.length;
        if (len == P256_BYTE_LEN || len == P384_BYTE_LEN || len == P521_BYTE_LEN) {
            return bytes;
        }
        bytes = len < P256_BYTE_LEN ? Bytes.prepad(bytes, P256_BYTE_LEN) : (len < P384_BYTE_LEN ? Bytes.prepad(bytes, P384_BYTE_LEN) : Bytes.prepad(bytes, P521_BYTE_LEN));
        return bytes;
    }

    @Override
    public BigInteger applyFrom(byte[] bytes) {
        return Converters.BIGINT_UBYTES.applyFrom(bytes);
    }
}

