/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.fabric_1_19;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.class_1267;
import net.minecraft.class_1940;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_31;
import net.minecraft.class_3176;
import net.minecraft.server.MinecraftServer;
import net.opanel.common.OPanelDifficulty;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.fabric_helper.BaseFabricSave;
import net.opanel.fabric_helper.FabricUtils;

public class FabricSave
extends BaseFabricSave
implements OPanelSave {
    private class_2487 nbt;

    public FabricSave(MinecraftServer server, Path path) {
        super(server, path);
        try {
            this.nbt = class_2507.method_30613((File)this.savePath.resolve("level.dat").toFile()).method_10562("Data");
            if (this.nbt.method_33133()) {
                throw new IOException("Cannot find a valid level.dat");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void saveNbt() throws IOException {
        class_2487 dataNbt = new class_2487();
        dataNbt.method_10566("Data", (class_2520)this.nbt);
        class_2507.method_30614((class_2487)dataNbt, (File)this.savePath.resolve("level.dat").toFile());
    }

    @Override
    public String getDisplayName() {
        return this.nbt.method_10558("LevelName").replaceAll("\u00c2", "");
    }

    @Override
    public void setDisplayName(String displayName) throws IOException {
        this.nbt.method_10582("LevelName", displayName);
        this.saveNbt();
    }

    @Override
    public OPanelGameMode getDefaultGameMode() {
        int gamemode = this.nbt.method_10550("GameType");
        return OPanelGameMode.fromId(gamemode);
    }

    @Override
    public void setDefaultGameMode(OPanelGameMode gamemode) throws IOException {
        this.nbt.method_10569("GameType", gamemode.getId());
        this.saveNbt();
    }

    @Override
    public OPanelDifficulty getDifficulty() throws IOException {
        if (this.isCurrent()) {
            return OPanelDifficulty.fromId(this.getCurrentWorld().method_8407().method_5461());
        }
        byte difficulty = this.nbt.method_10571("Difficulty");
        return OPanelDifficulty.fromId(difficulty);
    }

    @Override
    public void setDifficulty(OPanelDifficulty difficulty) throws IOException {
        if (this.isCurrent()) {
            this.server.method_3776(class_1267.method_16691((String)difficulty.getName()), true);
        }
        this.nbt.method_10567("Difficulty", (byte)difficulty.getId());
        this.saveNbt();
    }

    @Override
    public boolean isDifficultyLocked() throws IOException {
        if (this.isCurrent()) {
            return this.getCurrentWorld().method_8401().method_197();
        }
        return this.nbt.method_10571("DifficultyLocked") == 1;
    }

    @Override
    public void setDifficultyLocked(boolean locked) throws IOException {
        if (this.isCurrent()) {
            this.server.method_19467(locked);
        }
        this.nbt.method_10567("DifficultyLocked", (byte)(locked ? 1 : 0));
        this.saveNbt();
    }

    @Override
    public boolean isHardcore() throws IOException {
        if (this.isCurrent()) {
            return this.server.method_3754();
        }
        return this.nbt.method_10571("hardcore") == 1;
    }

    @Override
    public void setHardcoreEnabled(boolean enabled) throws IOException {
        if (this.isCurrent()) {
            class_31 levelProperties = (class_31)this.getCurrentWorld().method_8401();
            class_1940 currentInfo = levelProperties.method_27433();
            class_1940 newInfo = new class_1940(currentInfo.method_27339(), currentInfo.method_8574(), enabled, currentInfo.method_27340(), currentInfo.method_8582(), currentInfo.method_27341(), currentInfo.method_29558());
            try {
                Field levelInfoField = class_31.class.getDeclaredField("levelInfo");
                levelInfoField.setAccessible(true);
                levelInfoField.set(levelProperties, newInfo);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("hardcore=.+", "hardcore=" + enabled));
            FabricUtils.forceUpdateProperties((class_3176)this.server);
        }
        this.nbt.method_10567("hardcore", (byte)(enabled ? 1 : 0));
        this.saveNbt();
    }

    @Override
    public HashMap<String, Boolean> getDatapacks() {
        HashMap<String, Boolean> datapacks = new HashMap<String, Boolean>();
        class_2487 datapacksNbt = this.nbt.method_10562("DataPacks");
        datapacksNbt.method_10554("Enabled", 8).forEach(elem -> datapacks.put(elem.method_10714(), true));
        datapacksNbt.method_10554("Disabled", 8).forEach(elem -> datapacks.put(elem.method_10714(), false));
        return datapacks;
    }

    @Override
    public void toggleDatapack(String id, boolean enabled) throws IOException {
        Boolean currentEnabled = this.getDatapacks().get(id);
        if (currentEnabled == null || currentEnabled == enabled) {
            return;
        }
        if (id.equals("vanilla")) {
            return;
        }
        if (this.isCurrent()) {
            this.server.method_3734().method_44252(this.server.method_3739(), "datapack " + (enabled ? "enable" : "disable") + " \"" + id + "\"");
        }
        class_2487 datapacksNbt = this.nbt.method_10562("DataPacks");
        if (enabled) {
            datapacksNbt.method_10554("Disabled", 8).remove((Object)class_2519.method_23256((String)id));
            datapacksNbt.method_10554("Enabled", 8).add((Object)class_2519.method_23256((String)id));
        } else {
            datapacksNbt.method_10554("Enabled", 8).remove((Object)class_2519.method_23256((String)id));
            datapacksNbt.method_10554("Disabled", 8).add((Object)class_2519.method_23256((String)id));
        }
        this.saveNbt();
    }
}

