/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_21_9;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.LevelResource;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.common.OPanelWhitelist;
import net.opanel.common.features.CodeOfConductFeature;
import net.opanel.forge_1_21_9.ForgeOfflinePlayer;
import net.opanel.forge_1_21_9.ForgePlayer;
import net.opanel.forge_1_21_9.ForgeSave;
import net.opanel.forge_1_21_9.ForgeWhitelist;
import net.opanel.forge_1_21_9.Main;
import net.opanel.forge_helper.BaseForgeServer;
import net.opanel.utils.Utils;

public class ForgeServer
extends BaseForgeServer
implements OPanelServer,
CodeOfConductFeature {
    public ForgeServer(MinecraftServer server) {
        super(server);
    }

    @Override
    public byte[] getFavicon() {
        byte[] serverIconPNG = super.getFavicon();
        if (serverIconPNG != null) {
            return serverIconPNG;
        }
        ServerStatus status = this.server.getStatus();
        if (status == null) {
            return null;
        }
        Optional faviconOptional = status.favicon();
        if (faviconOptional.isEmpty()) {
            return null;
        }
        ServerStatus.Favicon favicon = (ServerStatus.Favicon)faviconOptional.get();
        return favicon.iconBytes();
    }

    @Override
    public void setFavicon(byte[] iconBytes) throws IOException {
        super.setFavicon(iconBytes);
        ServerStatus status = this.server.getStatus();
        ServerStatus.Favicon favicon = new ServerStatus.Favicon(iconBytes);
        ServerStatus newStatus = new ServerStatus(status.description(), status.players(), status.version(), Optional.of(favicon), status.enforcesSecureChat(), status.forgeData());
        try {
            Field statusIconField = MinecraftServer.class.getDeclaredField("statusIcon");
            statusIconField.setAccessible(true);
            statusIconField.set(this.server, favicon);
            Field statusField = MinecraftServer.class.getDeclaredField("status");
            statusField.setAccessible(true);
            statusField.set(this.server, newStatus);
        }
        catch (Exception e) {
            Main.LOGGER.warn("Cannot reload server favicon.");
        }
    }

    @Override
    public List<OPanelSave> getSaves() {
        ArrayList<OPanelSave> list = new ArrayList<OPanelSave>();
        try (Stream<Path> stream = Files.list(Paths.get("", new String[0]));){
            stream.filter(path -> Files.exists(path.resolve("level.dat"), new LinkOption[0]) && !Files.isDirectory(path.resolve("level.dat"), new LinkOption[0])).map(Path::toAbsolutePath).forEach(path -> {
                ForgeSave save = new ForgeSave(this.server, (Path)path);
                list.add(save);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public OPanelSave getSave(String saveName) {
        Path savePath = Paths.get("", new String[0]).resolve(saveName);
        if (!Files.exists(savePath, new LinkOption[0]) || !Files.exists(savePath.resolve("level.dat"), new LinkOption[0])) {
            return null;
        }
        return new ForgeSave(this.server, savePath.toAbsolutePath());
    }

    @Override
    public List<OPanelPlayer> getOnlinePlayers() {
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>();
        List players = this.server.getPlayerList().getPlayers();
        for (ServerPlayer serverPlayer : players) {
            ForgePlayer player = new ForgePlayer(serverPlayer, this.server);
            list.add(player);
        }
        return list;
    }

    @Override
    public List<OPanelPlayer> getPlayers() {
        Path playerDataPath = this.server.getWorldPath(LevelResource.PLAYER_DATA_DIR);
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>(this.getOnlinePlayers());
        try (Stream<Path> stream = Files.list(playerDataPath);){
            stream.filter(item -> !Files.isDirectory(item, new LinkOption[0]) && item.toString().endsWith(".dat")).forEach(item -> {
                try {
                    String uuid = item.getFileName().toString().replace(".dat", "");
                    ServerPlayer serverPlayer = this.server.getPlayerList().getPlayer(UUID.fromString(uuid));
                    if (serverPlayer != null && !serverPlayer.hasDisconnected()) {
                        return;
                    }
                    ForgeOfflinePlayer player = new ForgeOfflinePlayer(this.server, UUID.fromString(uuid));
                    list.add(player);
                }
                catch (Exception e) {
                    Main.LOGGER.warn("Cannot read the player data from " + String.valueOf(item.getFileName()) + ": " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<String> getBannedIps() {
        Collection entries = this.server.getPlayerList().getIpBans().getEntries();
        ArrayList<String> list = new ArrayList<String>();
        entries.forEach(entry -> list.add((String)entry.getUser()));
        return list;
    }

    @Override
    public void banIp(String ip2) {
        if (this.getBannedIps().contains(ip2)) {
            return;
        }
        this.server.getPlayerList().getIpBans().add(new IpBanListEntry(ip2));
    }

    @Override
    public void pardonIp(String ip2) {
        if (!this.getBannedIps().contains(ip2)) {
            return;
        }
        this.server.getPlayerList().getIpBans().remove(ip2);
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.server.getPlayerList().isUsingWhitelist();
    }

    @Override
    public void setWhitelistEnabled(boolean enabled) {
        this.server.setUsingWhitelist(enabled);
    }

    @Override
    public OPanelWhitelist getWhitelist() {
        return new ForgeWhitelist(this.server.getPlayerList().getWhiteList());
    }

    @Override
    public HashMap<String, Object> getGamerules() {
        CompoundTag gamerulesNbt = this.server.getGameRules().createTag();
        HashMap<String, Object> gamerules = new HashMap<String, Object>();
        for (String key : gamerulesNbt.keySet()) {
            String valueStr = gamerulesNbt.getStringOr(key, "");
            if (valueStr.equals("true") || valueStr.equals("false")) {
                gamerules.put(key, Boolean.valueOf(valueStr));
                continue;
            }
            if (Utils.isNumeric(valueStr)) {
                gamerules.put(key, Integer.valueOf(valueStr));
                continue;
            }
            gamerules.put(key, valueStr);
        }
        return gamerules;
    }

    @Override
    public void setGamerules(final HashMap<String, Object> gamerules) {
        final HashMap<String, Object> currentGamerules = this.getGamerules();
        final GameRules gameRulesObj = this.server.getGameRules();
        gameRulesObj.visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                super.visit(key, type);
                String ruleName = key.getId();
                Object value = gamerules.get(ruleName);
                if (value == null) {
                    return;
                }
                Object currentValue = currentGamerules.get(ruleName);
                if (value.equals(currentValue)) {
                    return;
                }
                GameRules.Value rule = type.createRule();
                if (rule instanceof GameRules.BooleanValue) {
                    ((GameRules.BooleanValue)rule).set(((Boolean)value).booleanValue(), ForgeServer.this.server);
                    gameRulesObj.getRule(key).setFrom(rule, ForgeServer.this.server);
                } else if (rule instanceof GameRules.IntegerValue) {
                    int n = ((Number)value).intValue();
                    ((GameRules.IntegerValue)rule).set(n, ForgeServer.this.server);
                    gameRulesObj.getRule(key).setFrom(rule, ForgeServer.this.server);
                } else {
                    ForgeServer.this.sendServerCommand("gamerule " + ruleName + " " + String.valueOf(value));
                }
            }
        });
    }
}

